<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans
 */
/**
 * @file ConcreteBeanComparator.php
 * @brief This interface is ConcreteBeanComparator.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ConcreteBeanComparator.php 24 2007-08-01 08:33:15Z ishitoya $
 *
 * Abstract ConcreteBeanComparator.
 */

/**
 * @class Ficus_ConcreteBeanComparator
 */
class Ficus_ConcreteBeanComparator extends Ficus_Bean
implements Ficus_BeanComparator{
    protected $target = null;
    protected $ascending = true;

    public function __construct($target){
        $this->target = $target;
    }

    /**
     * compare method
     */
    public function compare($a, $b){
        $dataA = $a->get($this->targetProperty);
        $dataB = $b->get($this->targetProperty);
        if($this->ascending){
            return ($dataA < $dataB) ? -1 : 1;
        }else{
            return ($dataA > $dataB) ? -1 : 1;
        }
    }
}
