<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans.annotation
 */
/**
 * @file BeanAnnotationAccessor.php
 * @brief bean annotation accesor
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: BeanAnnotationAccessor.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once "ficus/beans/Bean.php";
require_once "ficus/lang/annotation/AuthorAnnotation.php";
require_once "ficus/lang/annotation/BriefAnnotation.php";
require_once "ficus/lang/annotation/ClassAnnotation.php";
require_once "ficus/lang/annotation/CommentAnnotation.php";
require_once "ficus/lang/annotation/ClassAnnotation.php";
require_once "ficus/lang/annotation/DefinedbyAnnotation.php";
require_once "ficus/lang/annotation/PackageAnnotation.php";
require_once "ficus/lang/annotation/VarAnnotation.php";
require_once "ficus/beans/annotation/BeanPropertyAnnotationAccessor.php";
require_once "ficus/beans/annotation/BeanClassAnnotationAccessor.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationProperty.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationClass.php";

/**
 * @class Ficus_BeanAnnotationAccessor
 */
abstract class Ficus_BeanAnnotationAccessor{
    const T_VAR = "var";
    const T_DEFINEDBY = "definedby";
    const T_NAME = "name";
    const T_TYPE = "type";
    const T_COMMENT = "comment";
    const T_QNAME = "qname";
    const T_BRIEF = "brief";
    const T_CLASS = "class";
    const T_PACKAGE = "package";
    const T_AUTHOR = "author";
    
    /**
     * @var $annotations
     */
    protected $annotations = null;

    /*
     * construct with bean
     * @param $annotations Ficus_ReflectionAnnotation
     */
    public function __construct($annotations){
        $this->annotations = $annotations;
    }

    /**
     * get accessor
     * @param $bean Ficus_Bean bean to parse
     * @throw Ficus_IllegalBeanException illegal bean.
     */
    public static final function getAccessor($bean){
        Ficus_ReflectionAnnotation::setPrefixes(array('Ficus_', 'Ficus_'));
        Ficus_Assert::isInstanceOf($bean, "Ficus_Bean");
        
        $refClass = new Ficus_ReflectionClass($bean);
        $annotations = new Ficus_ReflectionAnnotationClass($refClass);
        $class = new Ficus_BeanClassAnnotationAccessor($annotations);
        
        $properties = $refClass->getProperties();
        $propAnnotations = array();
        foreach($properties as $property){
            $property = 
              new Ficus_BeanPropertyAnnotationAccessor(
                  new Ficus_ReflectionAnnotationProperty($property));
            $class->addProperty($property);
        }
        return $class;
    }

    /**
     * get Property with name
     * @return Ficus_ReflectionAnnotationProperty annotations
     */
    public function getAnnotations(){
        return $this->annotations;
    }

    /**
     * get property name
     * @return string name of property
     */
    public function getName(){
        return $this->getAnnotation(self::T_NAME);
    }

    /**
     * get property type
     * @return string type of property
     */
    public function getType(){
        return $this->getAnnotation(self::T_TYPE);
    }

    /**
     * get property comment
     * @return string comment of property
     */
    public function getComment(){
        return $this->getAnnotation(self::T_COMMENT);
    }

    /**
     * get property label
     * @return string label of property
     */
    public function getLabel(){
        return $this->getAnnotation(self::T_BRIEF);
    }

    /*
     * get property qname
     * @return string qname of property
     */
    public function getQName(){
        return $this->getAnnotation(self::T_QNAME);
    }

    /**
     * get property definedby
     * @return string definedby of property
     */
    public function getDefinition(){
        return $this->getAnnotation(self::T_DEFINEDBY);
    }
    
    /**
     * get Annotation from name
     * @param $name string annotation name
     * @return string annotation value
     */
    abstract protected function getAnnotation($name);
}
?>
