<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans.annotation
 */
/**
 * @file BeanPropertyAnnotationAccessor.php
 * @brief bean property annotation accessor
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: BeanPropertyAnnotationAccessor.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once "ficus/beans/annotation/BeanAnnotationAccessor.php";

/**
 * @class Ficus_BeanPropertyAnnotationAccessor
 */
class Ficus_BeanPropertyAnnotationAccessor extends Ficus_BeanAnnotationAccessor{

    /**
     * domain
     */
    private $domain = null;
    
    /**
     * construct with bean
     * @param $annotations annotations
     */
    public function __construct($annotations){
        parent::__construct($annotations);
    }

    /**
     * set Domain
     */
    public function setDomain($domain){
        $this->domain = $domain;
    }
    
    /**
     * get Annotation from name
     * @param $name string annotation name
     * @return string annotation value
     */
    protected function getAnnotation($name){
        if($name == self::T_BRIEF){
            $annotation = $this->annotations->getAnnotation(self::T_BRIEF);
            return $annotation->getBrief();
        }else if($name == self::T_COMMENT){
            $annotation = $this->annotations->getAnnotation(self::T_COMMENT);
            return $annotation->getComment();
        }else if($name == self::T_DEFINEDBY){
            $annotation = $this->annotations->getAnnotation(self::T_DEFINEDBY);
            return $annotation->getDefinedBy();
        }else if($name == self::T_QNAME){
            $domain = $this->getDomain();
            return "$domain." . $this->getName();
        }else{
            $annotation = $this->annotations->getAnnotation(self::T_VAR);
            $name = "get" . ucfirst($name);
            return $annotation->{$name}();
        }
    }

    /**
     * get domain
     * @return string domain
     */
    public function getDomain(){
        return $this->domain;
    }
    
    /**
     * get range
     * @return string range
     */
    public function getRange(){
        $annotation = $this->annotations->getAnnotation(self::T_VAR);
        return $annotation->getType();
    }

    /**
     * is property is array
     * @return boolean is property is array
     */
    public function isArray(){
        $annotation = $this->annotations->getAnnotation(self::T_VAR);
        return $annotation->isArray();
    }

    /**
     * is property is class
     * @return boolean is property is class
     */
    public function isClass(){
        $annotation = $this->annotations->getAnnotation(self::T_VAR);
        return $annotation->isClass();
    }

    /**
     * is property is literal
     * @return boolean is property is literal
     */
    public function isLiteral(){
        return (!$this->isClass());
    }
}
?>
