<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans.serializer
 */
/**
 * @file ArrayBeanSerializer.php
 * @brief serialize bean to Array
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ArrayBeanSerializer.php 48 2007-09-20 07:21:07Z ishitoya $
 */

require_once "ficus/beans/serializer/BeanSerializer.php";

/**
 * @package ficus.beans.serializer
 * @class Ficus_ArrayBeanSerializer
 */
class Ficus_ArrayBeanSerializer implements Ficus_BeanSerializer{
    /**
     * constructor
     */
    public function __construct(){
    }

    /**
     * serialize bean to Array
     * @param $bean Ficus_Bean bean to serialize
     * @return string array
     */
    public function serialize($bean, $arguments = null){
        return $this->parseBean($bean);
    }

    /**
     * serialize one bean to RDFSchema
     * and if property value is Bean instance, call back this method.
     * @param $bean Ficus_Bean bean to parse
     * @return array generated array
     * @throw Ficus_MethodNotFoundException getter method not found
     */
    private function parseBean($bean){
        $result = Array();
        $properties = $bean->beanProperties();
        foreach($properties as $property){
            $value = $bean->{$property}();
            if(empty($value)){
                continue;
            }
            if(is_array($value) || $value instanceof Iterator){
                $temp = array();
                foreach($value as $v){
                    if(empty($v)){
                        continue;
                    }
                    if($v instanceof Ficus_Bean){
                        $temp[] = $this->parseBean($v);
                    }else{
                        $temp[] = $v;
                    }
                }
                $value = $temp;
            }else if($value instanceof Ficus_Bean){
                $value = $this->parseBean($value);
            }
            $result[$property] = $value;
        }
        return $result;
    }
}
?>
