<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans.serializer
 */
/**
 * @file BeanSerializerFactory.php
 * @brief Interface of Source code generators.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: BeanSerializerFactory.php 48 2007-09-20 07:21:07Z ishitoya $
 */

require_once "ficus/lang/ClassLoader.php";

/**
 * @package ficus.beans.serializer
 * @class Ficus_BeanSerializerFactory
 */
class Ficus_BeanSerializerFactory{
    const SIGNATURE = "Ficus_%sBeanSerializer";
    const PACKAGE = "beans.serializer.";
    /**
     * create serializer
     * @param $bean Ficus_Bean bean to serialize
     * @return string rdf string
     */
    public function create($type){
        try{
            $serializer = $type . "BeanSerializer";
            $instance = Ficus_BeanComponentFactory::getComponent($serializer);
            if($instance instanceof Ficus_BeanSerializer){
                return $instance;
            }
        }catch(S2Container_ComponentNotFoundRuntimeException $e){
        }
            
        try{
            $serializer = self::PACKAGE . $type;
            $instance = Ficus_ClassLoader::load($serializer);
            if($instance instanceof Ficus_BeanSerializer){
                return $instance;
            }
        }catch(Ficus_ClassNotFoundException $e){
        }
        
        $serializer = self::PACKAGE . sprintf(self::SIGNATURE, $type);
        return Ficus_ClassLoader::load($serializer);
    }
}
?>
