<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans.serializer
 */
/**
 * @file StringBeanSerializer.php
 * @brief serializer bean to string format
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: StringBeanSerializer.php 48 2007-09-20 07:21:07Z ishitoya $
 */

require_once "ficus/lang/Assert.php";
require_once "ficus/beans/Bean.php";
require_once "ficus/beans/serializer/BeanSerializer.php";
require_once "ficus/beans/annotation/BeanAnnotationAccessor.php";
require_once "ficus/beans/BeanComponentFactory.php";
require_once "kaibashira/RDF/RDFReader.php";
require_once "kaibashira/RDF/RDFWriter.php";

/**
 * @package ficus.beans.serializer
 * @class Ficus_StringBeanSerializer
 */
class Ficus_StringBeanSerializer implements Ficus_BeanSerializer{
    /**
     * serialize bean to String
     * @param $bean Ficus_Bean bean to serialize
     * @return string String string
     */
    public function serialize($bean, $arguments = null){
        $string = self::parseBean($bean);
        return $string;
    }

    /**
     * serialize one bean to RDF
     * and if property value is Bean instance, call back this method.
     * @param $bean Ficus_Bean bean to parse
     * @param $graph Ficus_Graph graph to add triple
     * @return Ficus_Bean result node
     */
    private function parseBean($bean){
        Ficus_Assert::typeHinting("Ficus_Bean", $bean);
        $accessor = Ficus_BeanAnnotationAccessor::getAccessor($bean);

        $properties = $accessor->getPropertyAnnotations();
        $return = "";
        foreach($properties as $property){
            $value = $bean->{$property->getName()}();
            if($property->isClass() && is_null($value) == false){
                $return .= $this->parseBean($value);
            }else{
                $return .= $value;
            }
        }
        return $return;
    }
}
?>
