<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.phing
 */
/**
 * @file PhingTest.php
 * @brief phing test
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PhingTest.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * executes phing test (depends on PHPUnit result formatting)
 */

require_once("ficus/exception/IllegalArgumentException.php");
require_once("ficus/cli/phing/Phing.php");
require_once("ficus/cli/phing/PhingTestResult.php");
require_once("ficus/lang/Runtime.php");

/**
 * @class Ficus_PhingTest
 */
class Ficus_PhingTest extends Ficus_Phing
{
    const COMMAND = "test";
    const PACKAGE = "-Dpackage=";

    /**
     * @var $package string package name
     */
    private $package;

    /**
     * constructor
     * @param $root string root dir
     * @param $package string package name
     */
    public function __construct($root, $package = null){
        parent::__construct($root);
        $this->package = $package;
    }

    /**
     * execute. this is depends on phpunit2 result format.
     * @return Ficus_PhingTestResult result of phing test.
     */
    public function onExecute(){
        $command = $this->createCommand();
        $output = Ficus_Runtime::exec($command);

        $error = $output[Ficus_Runtime::ERROR];
        unset($output[Ficus_Runtime::ERROR]);

        $result = new Ficus_PhingTestResult($output);
        return $result;
    }

    /**
     * create command
     * @return string command
     */
    protected function createCommand(){
        $command = parent::createCommand();
        $command .= self::COMMAND . " ";
        if(empty($this->package) == false){
            $command .= self::PACKAGE . $this->package;
        }
        return $command;
    }
}
?>
