<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.ffmpeg
 */
/**
 * @file SentenceAnalyzerChasenResultAggregator.php
 * @brief svn add
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: SentenceAnalyzerChasenResultAggregator.php 24 2007-08-01 08:33:15Z ishitoya $
 *
 * executes ffmpeg abstract class
 */

require_once("ficus/exception/IllegalArgumentException.php");


/**
 * @class Ficus_SentenceAnalyzerChasenResultAggregator
 */
class Ficus_SentenceAnalyzerChasenResultAggregator
extends Ficus_ConcreteBeanAggregator
{
    const PROPNAME = "results";
    const CLASS_NOUN = "noun";

    /**
     * constructor
     */
    public function __construct($results = array()){
        parent::__construct(self::PROPNAME, $results);
    }

    /**
     * create instance
     */
    protected function createInstance($values){
        return new Ficus_SentenceAnalyzerChasenResultAggregator($values);
    }

    /**
     * get noun
     */
    public function getNouns(){
        $ret = array();
        foreach($this->results as $result){
            if($result->class() < 40){
                $ret[] = $result;
            }
        }
        return $this->createInstance($ret);
    }

    /**
     * get proper noun
     */
    public function getProperNouns(){
        $ret = array();
        foreach($this->results as $result){
            if($result->class() < 12){
                $ret[] = $result;
            }
        }
        
        return $this->createInstance($ret);
    }

    /**
     * unique
     */
    public function unique(){
        $this->setTargetKey("word");
        return parent::unique();
    }

    /**
     * without
     */
    public function without($word){
        $this->setTargetKey("word");
        return parent::without($word);
    }

    /**
     * normalize
     */
    public function normalize(){
        mb_regex_encoding("UTF-8");
        $ret = array();
        foreach($this->results as $key => $result){
            $word = $result->word();
            if(mb_ereg("^[0-9a-zA-Zぁ-んァ-ン]$", $result->word())){
                continue;
            }
            $ret[] = $result;
        }
        return $this->createInstance($ret);
    }
}
?>
