<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net
 */
/**
 * @file URICharacters.php
 * @brief URICharacters for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: URICharacters.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * URICharacters for php
 */
/**
 * @class Ficus_URICharacters
 */
interface Ficus_URICharacters {

    /**
     * Gen delimiter charactor.
     */
    const C_COLON               = 0x3A; // :
    const C_SLASH               = 0x2F; // /
    const C_QUESTION            = 0x3F; // ?
    const C_SHARP               = 0x23; // #
    const C_LEFT_SQUARE_BRACKET = 0x5B; // [
    const C_RIGHT_SQUARE_BRACKET= 0x5D; // ]
    const C_ATMARK              = 0x40; // @

    /**
     * Sub delimiter charactor.
     */
    const C_EXCLAMATION         = 0x21;  // !
    const C_DOLLAR              = 0x24;  // $
    const C_AMPERSAND           = 0x26;  // &
    const C_APOSTROPHE          = 0x27;  // '
    const C_LEFT_CURLY_BRACKET  = 0x7B;  // {
    const C_RIGHT_CURLY_BRACKET = 0x7D;  // }
    const C_ASTERISK            = 0x2A;  // *
    const C_PLUS                = 0x2B;  // +
    const C_COMMA               = 0x2C;  // ,
    const C_SEMICOLON           = 0x3B;  // ;
    const C_EQUALS              = 0x3D;  // =

    /**
     * etc.
     */
    const C_HYPHEN              = 0x2D; // -
    const C_DOT                 = 0x2E; // .
    const C_UNDERBAR            = 0x5F; // _
    const C_TILDE               = 0x7E; // ~

    /**
     * Alphabet.
     */
    const C_CAPITAL_A           = 0x41;
    const C_CAPITAL_Z           = 0x5A;
    const C_SMALL_A             = 0x61;
    const C_SMALL_Z             = 0x7A;

    /**
     * Digit.
     */
    const C_ZERO                = 0x30;
    const C_NINE                = 0x39;

}
?>
