<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.blog
 */
/**
 * @file BlogAtomAPI.php
 * @brief atom blog api class
 * @author <a href="mailto:mzp@nagoya-u.jp">MIZUNO Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractScaffoldForeperson.php 19 2007-07-25 18:20:09Z ishitoya $
 */

require_once('phpatomapi/phpatomapi/class.wsse.php');
require_once('phpatomapi/phpatomapi/class.basicauth.php');
require_once('phpatomapi/phpatomapi/class.atomapi.php');
require_once('ficus/net/blog/BlogEntry.php');

/**
 * class for submit blog entry via AtomAPI
 *
 * @Class Ficus_BlogAtomAPI
 */
abstract class Ficus_AbstractBlogAtomAPI extends Ficus_AbstractBlogAPI{
    const ATOM_NEW = "POST";
    const ATOM_EDIT = "PUT";
    const ATOM_DELETE = "DELETE";
    const ATOM_GET = "GET";
    const KEY_POST = "service.post";
    const KEY_TITLE = "title";
    const KEY_EDIT = "service.edit";
    const KEY_FEED = "service.feed";
    const KEY_REL = "rel";
    const KEY_HREF = "href";

    /**
     * @param string endpoint of AtomAPI
     */
    public function __construct($endpoint){
        parent::__construct($endpoint);
    }

    /**
     * prepare
     */
    public function prepare(){
        $authObject = $this->createAuthObject($this->auth);
        $this->client->auth = $authObject;
        $this->client->authtype = $this->auth->type();
        $this->client->endpoint = $this->endpoint;
        if($this->client->verify_auth() == false){
            throw new Ficus_BlogAPIException("authentication verify is failed");
        }
        return $this;
    }
    
    /**
     * setter
     */
    public function setAuth($auth){
        $this->auth = $auth;
    }
    
    /**
     * send atom api request
     */
    protected function send($method, $url, $xml = ''){
        if(is_null($this->auth)){
            throw new Ficus_NotReadyException("authentication information is not initialized");
        }/*else if(is_null($this->target)){
            throw new Ficus_NotReadyException("target blog id is not initialized");
        }*/
        $authObject = $this->createAuthObject($this->auth);

        $request = new AtomRequest($method, $url,
                                   $authObject, $xml);
        $res = $request->exec();
        if($request->error()){
            global $ATOMAPI_ERROR_STRINGS;
            throw new Ficus_BlogAPIException($ATOMAPI_ERROR_STRINGS[$request->error()],$request->error());
        }
        return $request->get_response();
    }

    /**
     * create client
     * @param $endpoint string uri of endpoint
     */
    protected function createClient($endpoint){
        $atomapi = new AtomAPI($endpoint, null, null, null);
        return $atomapi;
    }

    /**
     * create authentication instance
     */
    protected function createAuthObject($auth){
        switch($auth->type()){
        case self::AUTH_BASIC:
            return new BasicAuth($auth->username(), $auth->password());
        case self::AUTH_WSSE:
            return new WSSE($auth->username(), $auth->password(), false);
        case self::AUTH_AMEBA:
            //return new WSSE($auth->username(), $auth->password(), false, true);
            $wsse = new WSSE($auth->username(), $auth->password(), false);
            $wsse->set_digest(base64_encode(pack('H*',sha1(
                $wsse->get_nonce()
                .$wsse->get_timestamp()
                .strtoupper(md5($auth->password()))
            ))));
            return $wsse;
        }
        
        throw new Ficus_UnkownAuthTypeException($auth->type());
    }

    /**
     * get endpoint
     * @param $type string endpoint type to fetch
     * @return string endpoint
     */
    protected function getUrl($type){
        if(isset($this->client->feeds[0][$type])){
            return $this->client->feeds[0][$type];
        }
        throw new Ficus_IllegalArgumentException("$type is not exists in feeds");
    }
    
}
?>