<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.blog
 */
/**
 * @file BlogXMLRPCAPI.php
 * @brief blogger blog api class
 * @author <a href="mailto:mzp@nagoya-u.jp">MIZUNO Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractScaffoldForeperson.php 19 2007-07-25 18:20:09Z ishitoya $
 */

require_once('XML/RPC.php');
require_once('ficus/net/blog/BlogEntry.php');

/**
 * class for submit entry via BloggerAPI
 *
 * Generally BloggerAPI use to fetch information of blog
 * Blog submit function of BloggerAPI is too simple to use
 *
 * @class Ficus_BlogXMLRPCAPI
 */
abstract class Ficus_AbstractBlogXMLRPCAPI extends Ficus_AbstractBlogAPI{
    /**
     * xml rpc client
     */
    protected $client; 
    
    /**
     * @param string XML-RPC endpoint
     */  
    public function __construct($endpoint){
        parent::__construct($endpoint);
    }

    /**
     * prepare
     */
    public function prepare(){
        $blogId = $this->getBlogs(0);
        $this->setTarget($blogId["blogid"]);
        return $this;
    }

    /**
     * send request via xml rpc
     * @param $name name of remote procedure
     * @param $params array of parameter to pass
     */
    protected function send($name, $params = array()){
        if(is_null($this->auth)){
            throw new Ficus_NotReadyException("authentication information is not initialized");
        }
        $msg = new XML_RPC_Message($name, $params);
        $res = $this->client->send($msg);

        if($res->faultCode()){
            if($res->faultCode() === 5){
                throw new Ficus_NotReadyException("blog provider is in maintainance");
            }
            throw new Ficus_BlogAPIException($res->faultString() . ":" . $res->faultCode());
        }

        $val = $res->value();
        return XML_RPC_decode($val);
    }

    /**
     * create XML_RPC_client instance
     * @param $endpoint string endpoint url
     * @return XML_RPC_client client class
     */
    protected function createClient($endpoint){
        $parsed = parse_url($endpoint);
        return new XML_RPC_Client($parsed['path'], $parsed['host']);
    }


    /**
     * create xml value
     * @param $value misc value
     * @param $type string of type
     * @return XML_RPC_Value created
     */
    protected function createValue($value, $type){
        return new XML_RPC_Value($value, $type);
    }

    /**
     * create int type value
     * @param $value misc value
     * @return XML_RPC_Value created
     */
    protected function int($value){
        return $this->createValue($value,'int');
    }

    /**
     * create string type value
     * @param $value misc value
     * @return XML_RPC_Value created
     */
    protected function string($value){
        return $this->createValue($value,'string');
    }
    
    /**
     * create boolean type value
     * @param $value misc value
     * @return XML_RPC_Value created
     */
    protected function bool($value){
        return $this->createValue($value,'boolean');
    }
}
?>