<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.blog
 */
/**
 * @file BlogAPI.php
 * @brief metaweblog blog api class
 * @author <a href="mailto:mzp@nagoya-u.jp">MIZUNO Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractScaffoldForeperson.php 19 2007-07-25 18:20:09Z ishitoya $
 */

require_once('ficus/net/blog/BlogBloggerAPI.php');

/**
 * blog post via metaWeblogAPI
 *
 * @class Ficus_BlogAPI
 */
interface Ficus_BlogAPI extends Ficus_BlogConstants{
    /**
     * prepare function
     */
    public function prepare();
    
    /**
     * post entry
     *
     * @param $entry Ficus_BlogEntry target entry
     * @return Ficus_BlogEntry posted entry
     */
    public function post(Ficus_BlogEntry $entry);
    
    /**
     * Edit entry, cannot specify the title of the entry
     * 
     * @param Ficus_BlogEntry target content
     * @return boolean true if succeeded
     */
    public function edit(Ficus_BlogEntry $entry);

    /**
     * delete the entry
     * @param Ficus_BlogEntry target entry
     * @return boolean true if succeeded
     */
    public function delete(Ficus_BlogEntry $entry);

    /**
     * publish category, 
     *
     * @param Blog_Entry target entry
     * @return bool true if succeeded
     */
    public function createCategory();
    
    /**
     * get list of category
     *
     * fetched data structure is like
     * array('categaryName'=>'xx','categoryId'=>'xxx')
     *
     * @param string target blog
     * @return array of category hash
     */
    public function getCategoryList();
    
    /**
     * set a category to the entry
     *
     * @param Blog_Entry target entry
     * @param hash category array('id'=>'<categoryId>','primary'=>true)
     * @return bool true if succeeded
     */
    public function assignCategory($entry, $category, $asPrimary = true);

    /**
     * get entry
     *
     * @param $entry Ficus_BlogEntry entry
     * @return Ficus_BlogEntry information
     */
    public function getEntry(Ficus_BlogEntry $entry);
    
    /**
     * get submitted entry
     *
     * @return array of entry
     */
    public function getEntries();

    /**
     * get editable blog with current user
     *
     * processable hash has the structure like
     * array('titleA'=>'blog id A','titleB'=>'blog id B')
     *
     * @return hash of editable blog
     */
    public function getBlogs($blogId = null);
}
?>