<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.blog
 */
/**
 * @file BlogAtomAPI.php
 * @brief atom blog api class
 * @author <a href="mailto:mzp@nagoya-u.jp">MIZUNO Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractScaffoldForeperson.php 19 2007-07-25 18:20:09Z ishitoya $
 */

require_once('ficus/net/blog/BlogEntry.php');

/**
 * class for submit blog entry via AtomAPI
 *
 * @Class Ficus_BlogAtomAPI
 */
class Ficus_BlogAtomAPI extends Ficus_AbstractBlogAtomAPI{
    /**
     * get submitted entry
     *
     * @return array of entry
     */
    public function getEntries(){
        $feed = $this->client->get_feed(0);
        return $feed->get_entries();
    }

    /**
     * get entry
     *
     * @param $entry Ficus_BlogEntry entry
     * @return Ficus_BlogEntry information
     */
    public function getEntry(Ficus_BlogEntry $entry){
        $entries = $this->client->get_entries(0);

        $result = $entries[0];
        $entry->setDescription($result->get_content());
        $links = $result->get_links();
        $link = $links[0]["href"];
        $title = $result->get_title();
        $entry->setTitle($title['title']);
        $entry->setLink($link);
        $entry->setPermaLink($link);
        return $entry;
    }
    
    /**
     * get editable Blog with current user
     *
     * processable hash has the structure like
     * array('titleA'=>'blog id A','titleB'=>'blog id B')
     *
     * @return hash editable blog's hash code
     */
    public function getBlogs($blogId = null){
        $blogs = array();
        $feeds = $this->client->get_feeds();
        foreach ($feeds as $feed){
            if ($feed[self::KEY_POST] && $feed[self::KEY_TITLE]){
                $blogs[$feed[self::KEY_TITLE]] = $feed[self::KEY_POST];
            }
        }

        if(is_null($blogId)){
            return $blogs;
        }else if(is_int($blogId)){
            $i = 0;
            foreach($blogs as $blog){
                if($i == $blogId){
                    return $i;
                }
                $i++;
            }
        }else{
            return $blogs[$blogId];
        }
    }
    
    /**
     * submit hash
     * $content['title'] as a title,
     * and $content['description'] will be treated as content
     * 
     * @param string endpoint Blog
     * @param hash of content
     * @return Ficus_BlogEntry submitted entry
     */
    public function post(Ficus_BlogEntry $entry){
        $xml = $entry->serialize(new Ficus_BlogAtomXMLEntrySerializer());
        $endpoint = $this->getUrl(self::KEY_POST);
        $result = $this->send(self::ATOM_NEW, $endpoint, $xml);
        $response = new SimpleXMLElement($result);
       	$links = $response->entry->link!=NULL ? $response->entry->link : $response->link; /* for ameblo : for others*/
        foreach($links as $link){
            if((string)$link[self::KEY_REL] == self::KEY_EDIT){
                return new Ficus_BlogEntry((string)$link[self::KEY_HREF]);
            }
        }
        return 0;
    }
    
    /**
     * edit entry
     * $content['title'] as a title,
     * and $content['description'] will be treated as content
     *
     * @param Ficus_BlogEntry target entry
     * @param hash of content
     * @return boolean true if succeeded
     */
    public function edit(Ficus_BlogEntry $entry){
        $xml = $entry->serialize(new Ficus_BlogAtomXMLEntrySerializer());
        return $this->send(self::ATOM_EDIT, $entry->id(), $xml);
    }
    
    /**
     * delete target entry
     * @param Ficus_BlogEntry target entry
     * @return boolean true if succeeded
     */
    public function delete(Ficus_BlogEntry $entry){
        return $this->send(self::ATOM_DELETE, $entry->id());
    }

}
?>