<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.blog
 */
/**
 * @file BlogBloggerAPI.php
 * @brief blogger blog api class
 * @author <a href="mailto:mzp@nagoya-u.jp">MIZUNO Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractScaffoldForeperson.php 19 2007-07-25 18:20:09Z ishitoya $
 */

require_once('XML/RPC.php');
require_once('ficus/net/blog/BlogEntry.php');

/**
 * class for submit entry via BloggerAPI
 *
 * Generally BloggerAPI use to fetch information of blog
 * Blog submit function of BloggerAPI is too simple to use
 *
 * @class Ficus_BlogBloggerAPI
 */
class Ficus_BlogBloggerAPI extends Ficus_AbstractBlogXMLRPCAPI{
    const BLOGGER_NEW = "blogger.newPost";
    const BLOGGER_EDIT = "blogger.editPost";
    const BLOGGER_DELETE = "blogger.deletePost";
    const BLOGGER_GETBLOGS = "blogger.getUsersBlogs";
    const KEY_BLOGNAME = "blogName";
    const KEY_BLOGID = "blogid";
    
    /**
     * post entry
     *
     * @param $entry Ficus_BlogEntry target entry
     * @return Ficus_BlogEntry posted entry
     */
    public function post(Ficus_BlogEntry $entry){
        $postid = $this->send(self::BLOGGER_NEW,
                              array($this->string($this->auth->appkey()),
                                    $this->string($this->target),
                                    $this->string($this->auth->username()),
                                    $this->string($this->auth->password()),
                                    $this->string($entry->description()),
                                    $this->bool($entry->publish())));
        return $entry->setId($postid);
    }
    
    /**
     * Edit entry, cannot specify the title of the entry
     * 
     * @param Ficus_BlogEntry target content
     * @return boolean true if succeeded
     */
    public function edit(Ficus_BlogEntry $entry){
        return $this->send(self::BLOGGER_EDIT,
                           array($this->string($this->auth->appkey()),
                                 $this->string($entry->id()),
                                 $this->string($this->auth->username()),
                                 $this->string($this->auth->password()),
                                 $this->string($entry->description()),
                                 $this->bool($entry->publish())));
    }
    

    /**
     * delete the entry
     * @param Ficus_BlogEntry target entry
     * @return boolean true if succeeded
     */
    public function delete(Ficus_BlogEntry $entry){
        return $this->send(self::BLOGGER_DELETE,
                           array($this->string($this->auth->appkey()),
                                 $this->string($entry->id()),
                                 $this->string($this->auth->username()),
                                 $this->string($this->auth->password()),
                                 $this->bool(true) // this parameter is ignored
                                 ));
    }

    /**
     * get editable blog with current user
     *
     * processable hash has the structure like
     * array('titleA'=>'blog id A','titleB'=>'blog id B')
     *
     * @return hash of editable blog
     */
    public function getBlogs($blogId = null){
        $blogs = $this->send(self::BLOGGER_GETBLOGS,
                              array($this->string($this->auth->appkey()),
                                    $this->string($this->auth->username()),
                                    $this->string($this->auth->password())));
        if(is_array($blogs) == false){
            throw new Ficus_BlogAPIException(self::BLOGGER_GETBLOGS . " has failed. perhaps authentication mistake?");
        }
        
        if(is_null($blogId)){
            return $blogs;
        }else{
            return $blogs[$blogId];
        }
    }
}
?>