<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.blog
 */
/**
 * @file BlogEntry.php
 * @brief blog entry class
 * @author <a href="mailto:mzp@nagoya-u.jp">MIZUNO Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractScaffoldForeperson.php 19 2007-07-25 18:20:09Z ishitoya $
 */
/**
 * Cupssulate The unique entry id.
 *
 * Generally Id will treated as a string.
 *
 * @Class Ficus_BlogEntry
 */
class Ficus_BlogEntry extends Ficus_Bean{
    /**
     * @var $id string unique ID
     */
    protected $id = null;

    /**
     * @var $title string title
     */
    protected $title = null;

    /**
     * @var $description string content
     */
    protected $description = null;

    /**
     * @var $created string date
     */
    protected $created = null;

    /**
     * @var $publish boolean
     */
    protected $publish = true;

    /**
     * @var $allowComments boolean allow comment
     */
    protected $allowComments = true;

    /**
     * @var $allowPings boolean allow ping
     */
    protected $allowPings = true;

    /**
     * @var $pingURIs array
     */
    protected $pingURIs = array();

    /**
     * @var $link string
     */
    protected $link = null;

    /**
     * @var $permaLink string
     */
    protected $permaLink = null;
    
    /**
     * @param string unique id
     */
    public function __construct($id = null){
        $this->id = $id;
        $this->created = date("c");
    }
}
?>