<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.blog
 */
/**
 * @file BlogMetaWeblogAPI.php
 * @brief metaweblog blog api class
 * @author <a href="mailto:mzp@nagoya-u.jp">MIZUNO Hiroki</a>
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractScaffoldForeperson.php 19 2007-07-25 18:20:09Z ishitoya $
 */

require_once('ficus/net/blog/BlogMetaWeblogAPI.php');

/**
 * class for MovableType API
 *
 * @class Ficus_BlogMovableTypeAPI
 */
class Ficus_BlogMovableTypeAPI extends Ficus_BlogMetaWeblogAPI{
    const MT_CATEGORYLIST = "mt.getCategoryList";
    const MT_SETCATEGORY = "mt.setPostCategories";
    const MT_PUBLISH = "mt.publishPost";
    const MT_SUPPORTED = "mt.supportedMethods";

    const KEY_PRIMARY = "primary";
    const KEY_ID = "id";
    const KEY_ISPRIMARY = "isPrimary";
    const KEY_CATEGORY = "categoryId";
    
    /**
     * get list of category
     *
     * fetched data structure is like
     * array('categaryName'=>'xx','categoryId'=>'xxx')
     *
     * @param string target blog
     * @return array of category hash
     */
    public function getCategoryList(){
        return $this->send(self::MT_CATEGORYLIST,
                           array($this->string($this->target),
                                 $this->string($this->auth->username()),
                                 $this->string($this->auth->password())));
    }
    
    /**
     * set a category to the entry
     *
     * @param Blog_Entry target entry
     * @param hash category array('id'=>'<categoryId>','primary'=>true)
     * @return bool true if succeeded
     */
    public function setCategories($entry, $categories){
        /*
        $category = array();
        
        foreach($categories as $c){
            $primary = array_key_exists('primary',$c) ? $c['primary'] : false;
            $s = $this->createValue(array('categoryId'=>$this->string($c['id']),
                                          'isPrimary'=>$this->bool($primary)),
                                    'struct');
            array_push($category,$s);
        }
        return $this->send('mt.setPostCategories',
                           array($this->string($entry->id()),
                                 $this->getUserName(),
                                 $this->getPassword(),
                                 $this->createValue($category,'array')));*/
    }
    
    /**
     * publish category, 
     *
     * @param Blog_Entry target entry
     * @return bool true if succeeded
     */
    public function publish($entry){
        return $this->send(self::MT_PUBLISH,
                           array($this->string($entry->id()),
                                 $this->string($this->auth->username()),
                                 $this->string($this->auth->password())));
    }
    
    public function getMethods(){
        return $this->send(self::MT_SUPPORTED);
    }
}
?>