<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db.s2dao.model.serializer
 */
/**
 * @file S2DaoBlogAtomXMLEntrySerializer.php
 * @brief deserialize Array to Bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: BlogAtomXMLEntrySerializer.php 17 2007-07-19 13:33:15Z ishitoya $
 */

require_once "ficus/net/blog/BlogEntry.php";
require_once "ficus/beans/serializer/BeanSerializer.php";
require_once "ficus/lang/Assert.php";

/**
 * @class Ficus_BlogAtomXMLEntrySerializer
 */
class Ficus_BlogAtomXMLEntrySerializer
implements Ficus_BeanSerializer{
    const DEFAULT_METHOD = "POST";
    
    /**
     * serialize entry from array
     * @param $entry Ficus_BlogEntry target entry
     * @return Ficus_S2DaoEntry entry
     */
    public function serialize($entry, $arguments = array()){
        Ficus_Assert::isInstanceOf($entry, "Ficus_BlogEntry");
        $atom = new AtomEntry();
        $atom->set_title($entry->title());
        $desc = htmlspecialchars($entry->description());
        $atom->set_content($desc);
        $xml = $atom->to_xml(self::DEFAULT_METHOD);
        //var_dump($atom);
        //var_dump($xml);
        return $xml;
    }
}
?>
