<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db.s2dao.model.serializer
 */
/**
 * @file S2DaoBlogMetaWeblogXMLRPCValueEntrySerializer.php
 * @brief deserialize XMLRPCValue to Bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: BlogMetaWeblogXMLRPCValueEntrySerializer.php 17 2007-07-19 13:33:15Z ishitoya $
 */

require_once "ficus/net/blog/BlogEntry.php";
require_once "ficus/beans/serializer/BeanSerializer.php";
require_once "ficus/lang/Assert.php";

/**
 * @class Ficus_BlogMetaWeblogXMLRPCValueEntrySerializer
 */
class Ficus_BlogMetaWeblogXMLRPCValueEntrySerializer
implements Ficus_BeanSerializer{
    const XMLRPC_STRUCT = "struct";
    const XMLRPC_STRING = "string";
    const XMLRPC_DATE = "dateTime.iso8601";
    const XMLRPC_INT = "int";
    const XMLRPC_ARRAY = "array";
    
    const KEY_CREATED = "dateCreated";
    const KEY_ALLOWCOMMENTS = "mt_allow_comments";
    const KEY_ALLOWPINGS = "mt_allow_pings";
    const KEY_PINGURIS = "mt_tb_ping_urls";
    const KEY_TITLE = "title";
    const KEY_DESCRIPTION = "description";

    const KEY_NAME = "name";
    const KEY_TYPE = "type";

    private static $list =
      array('title'         => array(self::KEY_NAME => self::KEY_TITLE,
                                     self::KEY_TYPE => self::XMLRPC_STRING),
            'description'   => array(self::KEY_NAME => self::KEY_DESCRIPTION,
                                     self::KEY_TYPE => self::XMLRPC_STRING),
// unsupported paramter for DTI blog
//            'created'       => array(self::KEY_NAME => self::KEY_CREATED,
//                                     self::KEY_TYPE => self::XMLRPC_DATE),
            'allowComments' => array(self::KEY_NAME => self::KEY_ALLOWCOMMENTS,
                                     self::KEY_TYPE => self::XMLRPC_INT),
            'allowPings'    => array(self::KEY_NAME => self::KEY_ALLOWPINGS,
                                     self::KEY_TYPE => self::XMLRPC_INT),
            'pingURIs'      => array(self::KEY_NAME => self::KEY_PINGURIS,
                                     self::KEY_TYPE => self::XMLRPC_ARRAY));
    
    /**
     * deserialize entry from array
     * @param $entry Ficus_BlogEntry to serialize
     * @return Ficus_S2DaoEntry entry
     */
    public function serialize($entry, $arguments = array()){
        Ficus_Assert::isInstanceOf($entry, "Ficus_BlogEntry");
        $struct = array();

        $class = new ReflectionClass($entry);
        $properties = $class->getProperties();
        foreach($properties as $property){
            $name = $property->getName();
            $value = $entry->{$name}();
            if(isset(self::$list[$name])){
                $key = self::$list[$name][self::KEY_NAME];
                $type = self::$list[$name][self::KEY_TYPE];
                $struct[$key] = $this->createValue($value, $type);
            }else{
                $struct[$name] =
                    $this->createValue($value, self::XMLRPC_STRING);
            }
        }
        return new XML_RPC_Value($struct, self::XMLRPC_STRUCT);
    }

    /**
     * create xml value
     * @param $value misc value
     * @param $type string of type
     * @return XML_RPC_Value created
     */
    protected function createValue($value, $type){
        return new XML_RPC_Value($value, $type);
    }
}
?>
