<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.rmi.flickr
 */
/**
 * @file FlickrPhoto.php
 * @brief
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PDODatabase.php 26 2007-08-01 13:56:06Z ishitoya $
 * 
 *
 */

/**
 * @class Ficus_FlickrPhoto
 */
class Ficus_FlickrPhoto extends Ficus_Bean{
    protected $id = null;
    protected $owner = null;
    protected $secret = null;
    protected $server = null;
    protected $farm = null;
    protected $title = null;
    protected $isPublic = false;
    protected $isFriend = false;
    protected $ownername = null;
    protected $dateTaken = null;
    protected $dateTakenGranularity = null;
    protected $uri = null;

    public function __construct($flickrResult = array()){
        if(empty($flickrResult)){
            return;
        }
        $this->id = $flickrResult["id"];
        $this->owner = $flickrResult["owner"];
        $this->secret = $flickrResult["secret"];
        $this->server = $flickrResult["server"];
        $this->farm = $flickrResult["farm"];
        $this->title = $flickrResult["title"];
        $this->isPublic = (boolean)$flickrResult["ispublic"];
        $this->isFriend = (boolean)$flickrResult["isfriend"];
        $this->ownername = $flickrResult["ownername"];
        $this->dateTaken = $flickrResult["datetaken"];
        $this->dateTakenGranularity = $flickrResult["datetakengranularity"];
    }
}
?>