<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.rmi.photozou
 */
/**
 * @file PhotozouPhoto.php
 * @brief
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PDODatabase.php 26 2007-08-01 13:56:06Z ishitoya $
 * 
 *
 */

/**
 * @class Ficus_PhotozouPhoto
 */
class Ficus_PhotozouPhoto extends Ficus_Bean{
    protected $photoId = null;
    protected $userId = null;
    protected $albumId = null;
    protected $photoTitle = null;
    protected $favoriteNum = 0;
    protected $commentNum = 0;
    protected $copyright = 0;
    protected $copyrightCommercial = null;
    protected $copyrightModifications = null;
    protected $registTime = null;
    protected $tags = null;
    protected $url = null;
    protected $imageUrl = null;
    protected $originalImageUrl = null;
    protected $thumbnailImageUrl = null;
    protected $largeTag = null;
    protected $mediumTag = null;
    

    public function __construct($photozouResult = array()){
        if(empty($photozouResult)){
            return;
        }
        $this->photoId = $photozouResult["photo_id"];
        $this->userId = $photozouResult["user_id"];
        $this->albumId = $photozouResult["album_id"];
        $this->favoriteNum = $photozouResult["favorite_num"];
        $this->commentNum = $photozouResult["comment_num"];
        $this->copyright = $photozouResult["copyright"];
        $this->registTime = $photozouResult["regist_time"];
        $this->url = $photozouResult["url"];
        $this->imageUrl = $photozouResult["image_url"];
        $this->originalImageUrl = $photozouResult["original_image_url"];
        $this->thumbnailImageUrl = $photozouResult["thumbnail_image_url"];
        $this->largeTag = $photozouResult["large_tag"];
        $this->mediumTag = $photozouResult["medium_tag"];

        if(isset($photozouResult["tags"])){
            $this->tags = $photozouResult["tags"];
        }
        if(isset($photozouResult["copyright_commercial"])){
            $this->copyrightCommercial =
                $photozouResult["copyright_commercial"];
        }
        if(isset($photozouResult["copyright_modifications"])){
            $this->copyrightModifications =
                $photozouResult["copyright_modifications"];
        }
        if(isset($photozouResult["photo_title"])){
            $this->photoTitle = $photozouResult["photo_title"];
        }else{
            if(preg_match('/alt=\"(.*?)\"/', $this->largeTag, $regs)){
                $this->photoTitle = $regs[1];
            }
        }
    }
}
?>