<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file AbstractInlinePage.php
 * @brief abstract inline Page
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractInlinePage.php 22 2007-07-30 05:42:10Z ishitoya $
 */

require_once("ficus/pages/InlinePage.php");
require_once("ficus/exception/IllegalArgumentException.php");

/**
 * @class Ficus_AbstractInlinePage
 */
abstract class Ficus_AbstractInlinePage extends Ficus_InlinePage{
    /**
     * constructor
     */
    protected function onConstruct(){
    }
    
    /**
     * on called
     * @param $mode string name of mode
     * @param $args array of args of do method
     */
    protected function onDo($mode, $args){
    }

    /**
     * on done
     * @param $mode string name of mode
     * @param $args array of args of do method
     */
    protected function onDone($mode, $args){
        $this->display();
    }

    /**
     * on exception
     * @param $mode string name of mode
     * @param $args array of args of do method
     * @param $exception Exception exception
     */
    protected function onException($mode, $args, $exception){
        $template = Ficus_Registry::search(self::REGISTRY_EXCEPTION_TEMPLATE);
        if($template){
            $this->display($template);
        }else{
            $this->display(self::DEFAULT_EXCEPTION_TEMPLATE);
        }
    }

    /**
     * show default
     */
    public function doDefault(){
    }

}
?>