<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file PageActionPair.php
 * @brief page action pair
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: Page.php 17 2007-07-19 13:33:15Z ishitoya $
 */

require_once("ficus/pages/PageConstants.php");
require_once("ficus/pages/PageComponentFactory.php");
require_once("ficus/exception/PropertyNotFoundException.php");
require_once("ficus/exception/MethodNotFoundException.php");

/**
 * @class Ficus_PageActionPair
 */
class Ficus_PageActionPair extends Ficus_Bean{
    /**
     * @var $page string page name
     */
    protected $page = null;
    /**
     * @var $action string action name
     */
    protected $action = null;
    /**
     * @var $url string is url
     */
    protected $url = false;

    /**
     * set page
     * @param $page string name of page or url
     */
    public function setPage($page){
        if(preg_match('/^https?:\/\//', $page)){
            $this->url = true;
        }
        $this->page = $page;
    }
    
    /**
     * toString
     */
    public function __toString(){
        return $this->page . "_" . $this->action;
    }
}
?>
