<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file PageAuthenticationManager.php
 * @brief authentication manager
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PageAuthenticationManager.php 19 2007-07-25 18:20:09Z ishitoya $
 */

/**
 * @class Ficus_PageAuthenticationManager
 */
interface Ficus_PageAuthenticationManager extends Ficus_PageConstants{
    /**
     * authenticate user
     * @param $visit Ficuas_VisitBean information of user
     * @return Ficus_VisitBean information of user
     */
    public function authenticate($visit = null);

    /**
     * authorize user
     * @param $page Ficus_Page page
     * @param $visit Ficus_VisitBean information of user
     * @return boolean true if authorized
     */
    public function authorize($page, $visit = null);
}
?>