<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file PageTemplateResolver.php
 * @brief template resolver
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PageTemplateResolver.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/pages/ConcretePage.php");
require_once("ficus/pages/PageController.php");

/**
 * @class Ficus_PageTemplateResolver
 */
class Ficus_PageTemplateResolver{
    /**
     * get full path of the template
     * @param $template string template name
     * @return string fullpath of the template
     */
    public function getFullPath($template){
        $path = $this->templateDir . "/" . $template;
        return Ficus_Dir::normalize($path);
    }
    
    /**
     * search template
     * @param $page Ficus_Page page object
     * @param $mode string mode
     * @return String filename
     */
    public function resolve($page, $mode = null){
        if($page instanceof Ficus_Page){
            $class = new Ficus_Class($page);
            $package = str_replace(".", "/", $page->getPackage());
            $template = $class->shortname();
            $suffix = Ficus_PageComponentFactory::getPageLoader()->getSuffix();
            $template = substr($template, 0, strpos($template, $suffix));
        }else if(is_string($page)){
            $class = new Ficus_Class($page);
            $package = $class->package();
            $template = $class->shortname();
        }else{
            throw new Ficus_IllegalArgumentException("page is not Ficus_Page nor string");
        }
        if(is_null($mode) == false){
            $template .= ucfirst($mode);
        }
        if(empty($package)){
            return $template;
        }else{
            return str_replace(".", "/", $package) . "/" . $template;
        }
    }
}
?>