<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.listener
 */
/**
 * @file ActionLoggerListener.php
 * @brief abstract action listener
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ActionLoggerListener.php 35 2007-08-24 11:15:33Z ishitoya $
 */

/**
 * @class Ficus_ActionLoggerListener
 */
abstract class Ficus_ActionLoggerListener
extends Ficus_AbstractPageActionListener
implements Ficus_PageConstants{
    const REGISTRY_LOG = "pages.listeners.actionLogger";
    
    /**
     * logger settings
     */
    protected $settings = array();

    /**
     * @var $loggers array of CMMesse_Logger
     */
    protected $loggers = array();

    /**
     * constructor
     */
    public function __construct(){
        $this->settings = Ficus_Registry::search(self::REGISTRY_LOG);
    }

    /**
     * listen onDone event
     * @param $page Ficus_Page page to observe
     * @param $action string name of action
     * @param $request Ficus_PageRequest page request
     */
    public function onDo($page, $action, $request){
        $this->log($page, $action, $request, null, self::CONTEXT_DO);
    }

    /**
     * listen onDone event
     * @param $page Ficus_Page page to observe
     * @param $action string name of action
     * @param $request Ficus_PageRequest page request
     * @param $result mixed page execution result
     */
    public function onDone($page, $action, $request, $result){
        $this->log($page, $action, $request, $result, self::CONTEXT_DONE);
    }
 
    /**
     * call for loggers
     * @param $page Ficus_Page page to observe
     * @param $action string name of action
     * @param $request Ficus_PageRequest page request
     * @param $result mixed page execution result
     */
    public function log($page, $action, $request, $result, $context){
        $pagename = $page->pagename();
        $mode = $page->currentAction();

        if(isset($this->settings[$pagename]) == false){
            return;
        }

        $setting = $this->settings[$pagename];
        if($setting["action"] != $action ||
           $setting["context"] != $context){
            return;
        }

        $targets = explode(",", $setting["target"]);

        foreach($targets as $target){
            $target = trim($target);
            if(isset($this->loggers[$target]) == false){
                $this->loggers[$target] = $this->getLogger($target);
            }
            $this->loggers[$target]->log($page, $action, $request, $result);
        }
    }

    /**
     * get Logger instance from container
     * @param $name string name of logger
     * @return CMMesse_Logger logger instance
     */
    abstract protected function getLogger($name);
}
?>
