<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.listener
 */
/**
 * @file ActionMailerListener.php
 * @brief abstract action listener
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ActionMailerListener.php 35 2007-08-24 11:15:33Z ishitoya $
 */

/**
 * @class Ficus_ActionMailerListener
 */
class Ficus_ActionMailerListener extends Ficus_AbstractPageActionListener
implements Ficus_PageConstants{
    const MAILER_SETTINGS = "pagemailer";
    const CONTEXT_DO = "do";
    const CONTEXT_DONE = "done";

    protected $queue = null;

    /**
     * queue setter
     * @param $queue Ficus_MailQueue queue
     */
    public function setQueue($queue){
        $this->queue = $queue;
    }
    
    /**
     * listen onDone event
     * @param $page Ficus_Page page to observe
     * @param $action string name of action
     * @param $request Ficus_PageRequest page request
     */
    public function onDo($page, $action, $request){
        $this->log($page, $action, $request, self::CONTEXT_DO);
    }

    /**
     * listen onDone event
     * @param $page Ficus_Page page to observe
     * @param $action string name of action
     * @param $request Ficus_PageRequest page request
     * @param $result mixed page execution result
     */
    public function onDone($page, $action, $request, $result){
        $this->log($page, $action, $request, self::CONTEXT_DONE);
    }
 
    /**
     * send email
     * @param $page Ficus_Page page to observe
     * @param $action string name of action
     * @param $request Ficus_PageRequest page request
     * @param $context string context of send
     */
    protected function log($page, $action, $request, $context){
        $settings = Ficus_Registry::search("pages.listeners.actionMailer");
        $pagename = $page->getPagename();
        $setting = null;
        foreach($settings as $item){
            if($pagename  == $pagename &&
               $item["action"]  == $action &&
               $item["context"] == $context){
                $setting = $item;
            }                
        }
        if(is_null($item)){
            return;
        }
        while($mail = $this->queue->pop()){
            if(isset($setting["to"])){
                $mail->setTo($setting["to"]);
            }
            if(isset($setting["from"])){
                $mail->setFrom($setting["from"]);
            }
            if(isset($setting["subject"])){
                $mail->setFrom($setting["subject"]);
            }
            if(isset($setting["message"])){
                $mail->setFrom($setting["message"]);
            }
            $mail->send();
        }
    }
}
?>