<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file ListScaffoldForeperson.php
 * @brief table manager page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ListScaffoldForeperson.php 51 2007-09-24 13:39:45Z ishitoya $
 */

require_once("ficus/pages/AbstractPage.php");
require_once("ficus/config/Registry.php");
require_once("ficus/db/s2dao/models/serializer/S2DaoArrayEntityDeserializer.php");
require_once("common/AbstractPage.php");

/**
 * @class Ficus_ListScaffoldForeperson
 */
class Ficus_ListScaffoldForeperson extends Ficus_AbstractScaffoldForeperson{
    /**
     * constructor
     */
    protected function prepare($action){
        $this->enableNewMenu();
        $this->enableEditMenu();
        $this->enableDeleteMenu();
        $this->enableViewMenu();
    }

    /**
     * do default
     */
    public function doDefault(){
        $dto = $this->mediator->condition();
        if($this->mediator->request()->has(self::KEY_OFFSET)){
            $dto->setOffset($this->mediator->request()->get(self::KEY_OFFSET));
        }
        $helper = new S2Dao_PagerViewHelper($dto);
        $entities =
            $this->mediator->daoManager()->dao()->getWithCondition($dto);

        if($entities->isEmpty()){
            return "";
        }
        $this->mediator->scaffold()->setSubmitTitle("削除");
        $scaffold =
            $this->mediator->getScaffold($entities, self::ACTION_LIST);

        $this->mediator->smarty()->assign(self::KEY_HELPER, $helper);
        return $scaffold->serialize("ListScaffold");
    }

    /**
     * links
     */
    public function setNewLink($link, $title = null){
        $this->mediator->smarty()->assign("scaffold_newMenuLink", $link);
        $this->mediator->smarty()->assign("scaffold_newMenuTitle", $title);
    }
    public function setEditLink($link, $title = null){
        $this->mediator->smarty()->assign("scaffold_editMenuLink", $link);
        $this->mediator->smarty()->assign("scaffold_editMenuTitle", $title);
    }
    public function setDeleteLink($link, $title = null){
        $this->mediator->smarty()->assign("scaffold_deleteMenuLink", $link);
        $this->mediator->smarty()->assign("scaffold_deleteMenuTitle", $title);
    }
    public function setViewLink($link, $title = null){
        $this->mediator->smarty()->assign("scaffold_viewMenuLink", $link);
        $this->mediator->smarty()->assign("scaffold_viewMenuTitle", $title);
    }

    /**
     * menues
     */
    public function enableNewMenu(){
        $this->mediator->smarty()->assign("scaffold_newMenu", true);
    }
    public function disableNewMenu(){
        $this->mediator->smarty()->assign("scaffold_newMenu", false);
    }
    public function enableEditMenu(){
        $this->mediator->smarty()->assign("scaffold_editMenu", true);
    }
    public function disableEditMenu(){
        $this->mediator->smarty()->assign("scaffold_editMenu", false);
   }
    public function enableDeleteMenu(){
        $this->mediator->smarty()->assign("scaffold_deleteMenu", true);
    }
    public function disableDeleteMenu(){
        $this->mediator->smarty()->assign("scaffold_deleteMenu", false);
    }
    public function enableViewMenu(){
        $this->mediator->smarty()->assign("scaffold_viewMenu", true);
    }
    public function disableViewMenu(){
        $this->mediator->smarty()->assign("scaffold_viewMenu", false);
    }
}
?>
