<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file ViewScaffoldForeperson.php
 * @brief table manager page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ViewScaffoldForeperson.php 56 2007-10-01 09:13:43Z ishitoya $
 */

require_once("ficus/pages/AbstractPage.php");
require_once("ficus/config/Registry.php");
require_once("common/AbstractPage.php");

/**
 * @class Ficus_ViewScaffoldForeperson
 */
class Ficus_ViewScaffoldForeperson extends Ficus_AbstractScaffoldForeperson{
    protected $id = null;
    /**
     * constructor
     */
    protected function prepare($action){
        $this->disableEditMenu();
    }

    /**
     * set id
     */
    public function setId($id){
        $this->id = $id;
    }
    
    /**
     * view
     * @param $args array of arguments
     */
    public function doDefault(){
        if(is_null($this->id)){
            $entity = $this->mediator->entity();
        }else{
            $entity =
                $this->mediator->daoManager()->getSingleEntity($this->id);
        }
        $scaffold = $this->mediator->getScaffold($entity, self::ACTION_VIEW);

        $this->mediator->setEntity($entity);
        return $scaffold->serialize("ViewScaffold");
    }

    public function setEditLink($link, $title = null){
        $this->mediator->smarty()->assign("scaffold_editMenuLink", $link);
        $this->mediator->smarty()->assign("scaffold_editMenuTitle", $title);
    }

    public function enableEditMenu(){
        $this->mediator->smarty()->assign("scaffold_editMenu", true);
    }
    public function disableEditMenu(){
        $this->mediator->smarty()->assign("scaffold_editMenu", false);
   }
}    
?>
