<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file Form bean.php
 * @brief Form bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: Scaffold.php 19 2007-07-25 18:20:09Z ishitoya $
 *
 */

require_once("ficus/db/s2dao/models/S2DaoModelConstants.php");

/**
 * @class Ficus_Scaffold
 */
class Ficus_Scaffold extends Ficus_ConcreteBeanAggregator
implements Ficus_ScaffoldConstants, Ficus_S2DaoModelConstants{
    const DEFAULT_SUBMITTITLE = "次へ";
    /**
     * $page string form action
     */
    protected $page = null;
    
    /**
     * $method string form method post or get
     */
    protected $method = self::METHOD_POST;
    
    /**
     * $action string page's action, not a scaffold action
     */
    protected $action = null;

    /**
     * $target string target table name
     */
    protected $target = null;

    /**
     * $do string scaffold's action.
     */
    protected $do = null;

    /**
     * $submitTitle string submit button value
     */
    protected $submitTitle = self::DEFAULT_SUBMITTITLE;

    /**
     * $transition string transition
     */
    protected $transition = null;

    /**
     * $foreperson string foreperson
     */
    protected $foreperson = null;

    /**
     * $message string message
     */
    protected $message = null;

    /**
     * $entities array of entities
     */
    protected $entities = null;

    /**
     * $config Ficus_ScaffoldConfiguration
     */
    protected $config = null;

    /**
     * add
     */
    public function add($entity){
        if($entity instanceof Ficus_ScaffoldEntity){
            $name = $entity->qname();
            return parent::add($name, $entity);
        }else{
            return parent::add($entity);
        }
    }

    /**
     * constructor
     * @param $config Scaffold_TableConfiguration
     */
    public function __construct(){
        parent::__construct("entities");
    }

    /**
     * entity
     */
    public function entity($name){
        return $this->indexOf($name);
    }

    /**
     * search
     */
    public function search($name){
        $ret = null;
        foreach($this as $entity){
            $ret = $entity->search($name);
            if(is_null($ret) == false){
                return $ret;
            }
        }
        return null;
    }

    /**
     * currentTransition
     */
    public function currentTransition(){
        return $this->config->currentTransition();
    }
}
?>
