<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db.s2dao.model.serializer
 */
/**
 * @file S2DaoListScaffoldSerilizer.php
 * @brief deserialize Array to Bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ListScaffoldSerilizer.php 17 2007-07-19 13:33:15Z ishitoya $
 */

require_once "ficus/beans/serializer/BeanSerializer.php";
require_once "ficus/lang/Assert.php";
require_once "ficus/lang/reflect/ReflectionClass.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationProperty.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationClass.php";

/**
 * @class Ficus_ListScaffoldSerilizer
 */
class Ficus_ListScaffoldSerializer
extends Ficus_AbstractScaffoldSerializer{
    /**
     * serialize entity from array
     * @param $entity Ficus_S2DaoEntity target entity
     * @return string serialized data
     */
    public function serialize($scaffolds, $arguments = null){
        return $this->parse($scaffolds);
    }

    /**
     * serialize
     * @param $entity Ficus_S2DaoEntity entity to parse
     * @param $data Array array to parse
     * @return Ficus_S2DaoEntity result entity
     * @throw Ficus_IllegalBeanException illegal entity.
     */
    private function parse($scaffold){
        $rows = array();
        $entities = $scaffold->getEntities();
        foreach($entities as $entity){
            $results = $this->parseEntity($entity);
            $entity = $entity->indexOf(0)->entity();
            
            $this->smarty()->assign("data", $results);
            $this->smarty()->assign("entity", $entity);
            $rows[] = $this->smarty()->fetch("list/rowWithMenu.tpl");
        }

        $header = $entities[0]->serialize("ListHeaderScaffold");
        $this->smarty()->assign("header", $header);
        $this->smarty()->assign("rows", $rows);
        return $this->smarty()->fetch("list/table.tpl");
    }

    protected function parseEntity($parent){
        $entities = array();
        $values = array();
        foreach($parent as $entity){
            if($entity->isHidden() == false ||
               $entity->isTransitionParent()){
                if($entity->isComposite() && $entity->isSelect() == false){
                    $children = $this->parseEntity($entity);
                    $entities = array_merge($entities, $children);
                }else{
                    $values[] = $entity->serialize("ScaffoldData");
                }
            }
        }
        return array_merge($values, $entities);
    }
}
?>
