<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db.s2dao.model.serializer
 */
/**
 * @file S2DaoScaffoldAssistEntitySerializer.php
 * @brief deserialize Array to Bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ScaffoldAssistEntitySerializer.php 17 2007-07-19 13:33:15Z ishitoya $
 */

require_once "ficus/beans/serializer/BeanSerializer.php";
require_once "ficus/lang/Assert.php";
require_once "ficus/lang/reflect/ReflectionClass.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationProperty.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationClass.php";

/**
 * @class Ficus_ScaffoldAssistEntitySerializer
 */
class Ficus_ScaffoldAssistEntitySerializer
extends Ficus_AbstractScaffoldSerializer{
    /**
     * serialize entity from array
     * @param $entity Ficus_S2DaoEntity target entity
     * @return string serialized data
     */
    public function serialize($entity, $arguments = null){
        return implode("", $this->parse($entity));
    }

    /**
     * serialize
     * @param $entity Ficus_S2DaoEntity entity to parse
     * @param $data Array array to parse
     * @return Ficus_S2DaoEntity result entity
     * @throw Ficus_IllegalBeanException illegal entity.
     */
    private function parse($assist, $result = array()){
        if($assist->isComposite() == false){
            return $result;
        }

        if($assist->isTransitionParent()){
            foreach($assist->parts() as $part){
                $children = $this->parse($part);
                $result = array_merge($result, $children);
            }
        }
        
        if($assist->isHidden() ||
           $assist->isTransition() == false ||
           $assist->hasAssists() == false){
            return $result;
        }
        
        $assists = $assist->assists();
        $name = $assist->parentEntityName();
        foreach($assists as $key => $v){
            $this->smarty()->assign("name", $key);
            $this->smarty()->assign("value", $name);
            $result[$name] = $this->smarty()->fetch("form/assist.tpl");
        }

        return $result;
    }
}
?>
