package com.small_it_office.flatserve.core.response;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;


/**
 * ̃y[WɃtH[hĉ邱Ƃ킷NXłB
 * ̃NX̃IuWFNgHTTPT[rX\bh̖߂lƂĕԂƂŁA
 * w肵AhXHTTPtH[hs܂B
 */
public class ForwardResponse extends Response {

	/**
	 * tH[h̃pXB
	 */
	private String forwardPath;

	/**
	 * tH[hOɃNGXgXR[vŕۑĂIuWFNg̃}bvB
	 * tH[h̉ʂŎgp邽߂̃IuWFNgo^Ă܂B
	 */
	private Map<String, Object> requestScope = new HashMap<String, Object>();

	/**
	 * tH[hOɃZbVXR[vŕۑĂIuWFNg̃}bvB
	 * tH[h̉ʂŎgp邽߂̃IuWFNgo^Ă܂B
	 */
	private Map<String, Object> sessionScope = new HashMap<String, Object>();

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param path tH[h̃pXB
	 */
	public ForwardResponse(String path) {
		this.forwardPath = path;
	}

	/**
	 * content-type̓tH[hŐݒ肷邽߁Ã\bhłnullԂ܂B
	 * @return null
	 */
	protected String getContentType() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void writeResponse() throws IOException {
		RequestContext context = RequestContext.get();
		HttpServletRequest request = context.getHttpServletRequest();
		HttpServletResponse response = context.getHttpServletResponse();

		Set<String> rKeys = requestScope.keySet();
		for (String key : rKeys) {
			request.setAttribute(key, requestScope.get(key));
		}
		Set<String> sKeys = sessionScope.keySet();
		for (String key : sKeys) {
			request.getSession().setAttribute(key, sessionScope.get(key));
		}

		logger.debug("FSCORE-LOGD062", forwardPath);
		RequestDispatcher rd = request.getRequestDispatcher(forwardPath);
		try {
			rd.forward(request, response);
		} catch (ServletException e) {
			throw new ResponseFailException(Message.get("FSCORE-ERR016"), e);
		}
	}

	/**
	 * NGXgXR[vɃIuWFNgi[܂B
	 * ̃\bhŊi[ꂽIuWFNǵAtH[hO
	 * javax.servlet.http.HttpServletRequestIuWFNgsetAttribute\bhŊi[܂B
	 * @param key NGXgXR[vɊi[L[
	 * @param o i[IuWFNg
	 */
	public void setRequestScope(String key, Object o) {
		requestScope.put(key, o);
	}

	/**
	 * ZbVXR[vɃIuWFNgi[܂B
	 * ̃\bhŊi[ꂽIuWFNǵAtH[hO
	 * javax.servlet.http.HttpSessionIuWFNgsetAttribute\bhŊi[܂B
	 * @param key ZbVXR[vɊi[L[
	 * @param o i[IuWFNg
	 */
	public void setSessionScope(String key, Object o) {
		sessionScope.put(key, o);
	}

}
