package com.small_it_office.flatserve.core.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import com.small_it_office.shared.meslog.message.Message;
import com.small_it_office.flatserve.core.plugin.Plugin;
import com.small_it_office.flatserve.core.plugin.core.internal.Core;

/**
 * FlatServeɑ΂ݒ\NXłB
 * <p>
 * FlatServeł́Aݒt@CɋLq̂ł͂ȂÃNX̃IuWFNgɊi[܂B
 * {@link ApplicationInitializer}NX̃NX̃IuWFNg𐶐AKvȐݒli[܂B
 * </p>
 * <p>
 * ̃IuWFNgɊi[邱Ƃłݒ荀ڂ͉L̒ʂłB
 * <table border="1">
 * <tr>
 *   <th>ݒ荀</th>
 *   <th></th>
 *   <th>ݒ胁\bh</th>
 *   <th>ftHgl</th>
 * </tr>
 * <tr>
 *   <td>NGXgGR[fBO</td>
 *   <td>
 *     HTTPNGXg{fB̕GR[fBOB
 *     NGXgContent-Typeapplication/x-www-form-urlencoded̏ꍇ̂ݗLB
 *   </td>
 *   <td>{@link #setRequestEncoding(String)}</td>
 *   <td>UTF-8</td>
 * </tr>
 * <tr>
 *   <td>P[</td>
 *   <td>
 *     Hs̃P[BOȂǂ̃bZ[WɓKpB
 *   </td>
 *   <td>{@link #setLocale(Locale)}</td>
 *   <td>VXẽftHgP[</td>
 * </tr>
 * <tr>
 *   <td>pbP[Wʕ</td>
 *   <td>
 *     HTTPT[rXNXŜɋʂpbP[W̐擪̕B
 *     Ƃ΁AׂĂHTTPT[rXNX̃pbP[Wcom.foo.barŎn܂ꍇA
 *     setPackagePrefix("com.foo.bar")ݒ肷邱ƂŁAďoURLZk邱Ƃ\B
 *   </td>
 *   <td>{@link #setPackagePrefix(String)}</td>
 *   <td>Ȃ</td>
 * </tr>
 * <tr>
 *   <td>T[rXNX}bsO</td>
 *   <td>
 *     URIHTTPT[rXNX̃}bsOB
 *     Ƃ΁A"/foo"Ƃfoo.FooNXɃ}bsOƁA
 *     /contxtroot/foo/service.lsƂURIŃNGXgMꍇfoo.FooNXservice\bh
 *     T[rX\bhƂĎsB
 *   </td>
 *   <td>
 *     {@link #addRequestPathMapping(String, Class)},
 *     {@link #addRequestPathMapping(Map)},
 *     {@link #addRequestPathMapping(Properties)}
 *   </td>
 *   <td>Ȃ</td>
 * </tr>
 * <tr>
 *   <td>vOCo</td>
 *   <td>
 *     NXpX̃vOCœǂݍސݒB
 *     truȅꍇ́ANXpXɂvOCSĎIɓǂݍ݁ApB
 *     falsȅꍇ́AuvOCIvi{@link #addAvailablePlugin(Class)}jŎw肵vOCȊO͓ǂݍ܂ȂB
 *   </td>
 *   <td>
 *     {@link #setPluginAutoDetect(boolean)}
 *   </td>
 *   <td>true</td>
 * </tr>
 * <tr>
 *   <td>vOCI</td>
 *   <td>
 *     pvOC̎wB
 *     w肵vOCȊOǂݍ܂ȂB
 *     AuvOCovLȏꍇ͖B
 *   </td>
 *   <td>
 *     {@link #addAvailablePlugin(Class)}
 *   </td>
 *   <td>Ȃ</td>
 * </tr>
 * <tr>
 *   <td>HTTPT[rXȂꍇ̃tH[hURL</td>
 *   <td>
 *     NGXgURLɊYHTTPT[rXNX܂HTTPT[rX\bh݂ȂꍇɁAtH[hURLB
 *     null̏ꍇɂ̓tH[hAHTTP{fBX|XŕԂ܂B
 *   </td>
 *   <td>
 *     {@link #setServiceNotFoundForwardUrl(String)}
 *   </td>
 *   <td>null</td>
 * </tr>
 * 
 * <tr>
 *   <td>IvVݒ</td>
 *   <td>vOCŕKvƂŗL̐ݒIuWFNgB</td>
 *   <td>{@link #addOptionalConfig(Object)}</td>
 *   <td>Ȃ</td>
 * </tr>
 * </table>
 */
public class Config {

	/**
	 * pbP[WʕB
	 */
	private String packagePrefix;

	/**
	 * T[rXNX}bsOB
	 */
	private Map<String, Class<?>> requestPathMappings = new HashMap<String, Class<?>>();

	/**
	 * NGXgGR[fBOB
	 * ftHgUTF-8B
	 */
	private String requestEncoding = "UTF-8";

	/**
	 * s̃P[B
	 * w肵Ȃꍇ́AVXẽftHgKp܂B
	 */
	private Locale locale = Locale.getDefault();

	/**
	 * pvOC̃NẌꗗB
	 * {@link Plugin}C^[tF[XNX̖Oi[܂B
	 * {@link #pluginAutoDetect}falsȅꍇÃXgɓĂvOCKp܂B
	 * truȅꍇ͂̃tB[h̓e͖܂B
	 */
	private List<String> availablePlugins = new ArrayList<String>();

	/**
	 * NXpXォ玩IɃvOCToǂ̃tOB
	 * trueł΁ANXpXɑ݂vOCׂēǂݍ݁AKp܂B
	 */
	private boolean pluginAutoDetect = true;

	/**
	 * NGXgURLɑΉHTTPT[rXNXE\bh݂ȂꍇɃtH[hURLB
     * ݒlnulliftHgj̏ꍇ͋HTTP{fBԂ܂B
	 */
	private String serviceNotFoundForwardUrl;

	/**
	 * vOCŗL̐ݒMapB
	 * ^L[ƂMapɐݒIuWFNgi[܂B
	 */
	private Map<Class<?>, Object> optionalConfig = new HashMap<Class<?>, Object>();

	/**
	 * pbP[Wʕ̐ݒԂ܂B
	 * @return pbP[Wʕ
	 */
	public String getPackagePrefix() {
		return packagePrefix;
	}

	/**
	 * T[rXNX}bsOݒ肳ĂꍇANGXgpXɑ΂HTTPT[rXNXԂ܂B
	 * @param requestPath NGXgpX
	 * @return pXɃ}bsOꂽHTTPT[rXNXB}bsOݒ肳ĂȂnullB
	 */
	public Class<?> pathToClass(String requestPath) {
		return requestPathMappings.get(requestPath);
	}

	/**
	 * NGXgGR[fBO̐ݒԂ܂B
	 * @return NGXgGR[fBO
	 */
	public String getRequestEncoding() {
		return requestEncoding;
	}

	/**
	 * IvVݒԂ܂B
	 * IvVݒ̓vOCgp܂BIuWFNǧ^̓vOCɂĈقȂ܂B
	 * @param <T> IvVݒIuWFNǧ^
	 * @param configType IvVݒIuWFNǧ^\NX
	 * @return IvVݒ
	 */
	public <T> T getOptionalConfig(Class<T> configType) {
		return configType.cast(optionalConfig.get(configType));
	}

	/**
	 * T[rXNX}bsOǉ܂B
	 * NGXgpX́AReLXg[g̉̊KwA擪"/"܂߂̂ݒ肵܂B
	 * @param requestPath NGXgpX
	 * @param serviceClass HTTPT[rXNX
	 */
	public void addRequestPathMapping(String requestPath, Class<?> serviceClass) {
		this.requestPathMappings.put(requestPath, serviceClass);
	}

	/**
	 * T[rXNX̃}bsOǉ܂B
	 * NGXgpX́AReLXg[g̉̊KwA擪"/"܂߂̂ݒ肵܂B
	 * @param mapping NGXgpXHTTPT[rXNX̃}bsO
	 */
	public void addRequestPathMapping(Map<String, Class<?>> mapping) {
		this.requestPathMappings.putAll(mapping);
	}

	/**
	 * HTTPT[rXNX̃}bsOǉ܂B
	 * ̃\bhł́A}bsOvpeBt@CɋLqꍇȂǁA
	 * t@C烍[hPropertiesIuWFNĝ܂܈ɓnƂł܂B
	 * vpeB́A
	 * <pre>
	 * NGXgpX=HTTPT[rXNX
	 * </pre>
	 * ̌`łKv܂B
	 * NGXgpX́AReLXg[g̉̊KwA擪"/"܂߂̂ݒ肵܂B
	 * @param properties NGXgpXHTTPT[rXNX̃}bsO
	 */
	public void addRequestPathMapping(Properties properties) {
		Set<Object> keySet = properties.keySet();
		for (Object key : keySet) {
			String requestPath = (String)key;
			String serviceClassName = properties.getProperty(requestPath);
			Class<?> serviceClass;
			try {
				serviceClass = Class.forName(serviceClassName);
			} catch (ClassNotFoundException e) {
				throw new InitializationException(Message.get("FSCORE-ERR007", requestPath, serviceClassName), e);
			}
			addRequestPathMapping(requestPath, serviceClass);
		}
	}

	/**
	 * pbP[Wʕݒ肵܂B
	 * @param packagePrefix pbP[Wʕ
	 */
	public void setPackagePrefix(String packagePrefix) {
		this.packagePrefix = packagePrefix;
	}

	/**
	 * NGXgGR[fBOݒ肵܂B
	 * w肵ȂꍇAftHgƂUTF-8Kp܂B
	 * @param requestEncoding NGXgGR[fBO
	 */
	public void setRequestEncoding(String requestEncoding) {
		this.requestEncoding = requestEncoding;
	}

	/**
	 * s̃P[Ԃ܂B
	 * @return s̃P[
	 */
	public Locale getLocale() {
		return locale;
	}

	/**
	 * s̃P[ݒ肵܂B
	 * <p>
	 * ObZ[WObZ[W\[XohƂēǂݍލۂɁAw肵P[Kp܂B
	 * ݒ肵ȂꍇAVXẽftHgKp܂B
	 * </p>
	 * <p>
	 * AAvP[VNX̎s܂ł́AݒIuWFNg̓efȂ߁A
	 * KVXẽftHgP[Kp܂B
	 * </p>
	 * @param locale s̃P[
	 */
	public void setLocale(Locale locale) {
		this.locale = locale;
	}

	/**
	 * KpvOCw肵܂B
	 * w肵ȊÕvOC̓NXpXɉĂǂݍ܂ȂȂ܂BvOC̎w͂łǉł܂B
	 * ̃\bhsƁA{@link #isPluginAutoDetect()}\bhfalseԂ悤ɐݒ肳܂B
	 * ēx{@link #setPluginAutoDetect(boolean)}trueݒ肵ꍇA
	 * ̃\bhɂvOC̎w͖܂B
	 * @param pluginClass AvP[VŎgpvOC\NX
	 */
	public void addAvailablePlugin(Class<? extends Plugin> pluginClass) {
		pluginAutoDetect = false;
		availablePlugins.add(pluginClass.getName());
	}

	/**
	 * Ŏw肵ÕNXAKpvOCƂĎw肳Ă邩ǂԂ܂B
	 * @param pluginClassName {@link Plugin}C^[tF[XNX̊SCB
	 * @return {@link #addAvailablePlugin(Class)}\bhŒǉꂽNX̖OłtrueB
	 */
	public boolean isAvailablePlugin(String pluginClassName) {
		if (Core.class.getName().equals(pluginClassName)) {
			return true;
		}
		return availablePlugins.contains(pluginClassName);
	}

	/**
	 * vOCNXpXォ玩IɃvOCToǂݒ肵܂B
	 * @param autoDetect trueȂNXpX̃vOCׂēǂݍ݁EKpB
	 */
	public void setPluginAutoDetect(boolean autoDetect) {
		this.pluginAutoDetect = autoDetect;
	}

	/**
	 * vOCNXpXォ玩IɃvOCToǂԂ܂B
	 * @return ŃvOCToݒłtrueBftHgltrueB
	 */
	public boolean isPluginAutoDetect() {
		return pluginAutoDetect;
	}

    /**
     * NGXgURLɑΉHTTPT[rXNXE\bh݂ȂꍇɃtH[hURLԂ܂B
     * @return serviceNotFoundForwardUrl tH[hURLB
     */
    public String getServiceNotFoundForwardUrl() {
    	return serviceNotFoundForwardUrl;
    }

    /**
     * NGXgURLɑΉHTTPT[rXNXE\bh݂ȂꍇɃtH[hURLݒ肵܂B
     * <p>
     * HTTPT[rXNXE\bh݂Ȃꍇɂ́AHTTPXe[^XR[h404Ԃ܂B
     * ̂ƂAftHgł̓X|X{fB̏ԂłAtH[hURLw肷邱ƂŃuEUŔCӂ̉ʂ\邱Ƃł܂B
     * </p>
     * <p>
     * ݒlnulliftHgj̏ꍇ͋HTTP{fBԂ܂B
     * </p>
     * @param serviceNotFoundForwardUrl tH[hURLB
     */
    public void setServiceNotFoundForwardUrl(String serviceNotFoundForwardUrl) {
    	this.serviceNotFoundForwardUrl = serviceNotFoundForwardUrl;
    }

	/**
	 * vOCɂIvVݒǉ܂B
	 * vOCgpہAvOCɂĂ̓IvVݒIuWFNgǉKv܂B
	 * IvVݒIuWFNǧ^́AvOCɂĈقȂ܂B
	 * @param config IvVݒIuWFNg
	 */
	public void addOptionalConfig(Object config) {
		optionalConfig.put(config.getClass(), config);
	}

	/**
	 * ̃IuWFNgݒe𕶎ɂĕԂ܂B
	 * @return {@inheritDoc}
	 */
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("packagePrefix : ");
		builder.append(packagePrefix == null ? "" : packagePrefix);
		builder.append(", requestEncoding : ");
		builder.append(requestEncoding);
		builder.append(", locale : ");
		builder.append(locale);
		builder.append(", requestPathMappings includes ");
		builder.append(requestPathMappings.size());
		builder.append(" mappings");
		builder.append(", pluginAutoDetect : ");
		builder.append(pluginAutoDetect);
		builder.append(", availablePlugins : {");
		boolean needComma = false;
		for (String plugin : availablePlugins) {
			if (needComma) {
				builder.append(", ");
			} else {
				needComma = true;
			}
			builder.append(plugin);
		}
		builder.append("}");
		builder.append(", optionalConfig : {");
		Set<Class<?>> configClasses = optionalConfig.keySet();
		needComma = false;
		for (Class<?> configClass : configClasses) {
			if (needComma) {
				builder.append(", ");
			} else {
				needComma = true;
			}
			builder.append(configClass.getSimpleName());
		}
		builder.append("}");
		return builder.toString();
	}

}
