package com.small_it_office.flatserve.core.request.type.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Map;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.Param;
import com.small_it_office.flatserve.core.request.TrueValue;
import com.small_it_office.flatserve.core.request.internal.NullObject;
import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;


/**
 * HTTPT[rX\bḧboolean̏ꍇɃNGXgp[^Ƃ̃}bsOs܂B
 */
public class BooleanTypeMapping implements TypeMapping {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public MappedParameter mapParameter(Annotation[] annotations, Object readParam) {
		logger.debug("FSCORE-LOGD027", "boolean/Boolean", this.getClass().getSimpleName());
		if (readParam != null && readParam != NullObject.getInstance()) {
			logger.debug("FSCORE-LOGD028", readParam);
			return null;
		}
		RequestContext context = RequestContext.get();
		Map<String, Object> requestParams = context.getRequestParams();
		for (Annotation anno : annotations) {
			if (anno.annotationType() == Param.class) {
				String requestParamName = ((Param)anno).value();
				Object objParam = requestParams.get(requestParamName);
				MappedParameter mappedParam;
				if (objParam == null) {
					logger.debug("FSCORE-LOGD069", requestParamName);
					mappedParam = new MappedParameter(false, null);
				} else if (objParam instanceof String[] && Array.getLength(objParam) > 0) {
					TrueValue trueValueAnno = AnnotationUtil.findAnnotation(annotations, TrueValue.class);
					String strParam = ((String[])objParam)[0];
					if (trueValueAnno == null) {
						logger.debug("FSCORE-LOGD070", requestParamName);
						mappedParam = new MappedParameter(true, strParam);
					} else {
						String trueValue = trueValueAnno.value();
						boolean booleanValue = trueValue.equals(strParam);
						logger.debug("FSCORE-LOGD071", requestParamName, strParam, trueValue, booleanValue);
						mappedParam = new MappedParameter(booleanValue, strParam);
					}
				} else {
					logger.debug("FSCORE-LOGW003", requestParamName, objParam);
					mappedParam = new MappedParameter(false, null);
				}
				return mappedParam;
			}
		}
		logger.debug("FSCORE-LOGD034", "boolean/Boolean");
		return new MappedParameter(false, null);
	}

}
