package com.small_it_office.flatserve.core.request.type.internal;

import java.lang.annotation.Annotation;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.internal.NullObject;
import com.small_it_office.flatserve.core.request.internal.ParamNameConstants;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;


/**
 * HTTPT[rX\bḧ̌^HttpServletRequest̏ꍇ̃}bsOs܂B
 * mapParameter\bh́ÃReLXg񂩂擾HttpServletRequestIuWFNgPɕԂ܂B
 */
public class HttpServletRequestTypeMapping implements TypeMapping {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public MappedParameter mapParameter(Annotation[] annotations, Object readParam) {
		logger.debug("FSCORE-LOGD027", HttpServletRequest.class.getName(), this.getClass().getSimpleName());
		if (readParam != null && readParam != NullObject.getInstance()) {
			logger.debug("FSCORE-LOGD028", readParam);
			return null;
		}

		Map<String, Object> requestParams = RequestContext.get().getRequestParams();
		HttpServletRequest request = (HttpServletRequest)requestParams.get(ParamNameConstants.HTTP_SERVLET_REQUEST);
//		if (request instanceof FlatServeRequest) {
//			request = ((FlatServeRequest)request).getOriginalRequest();
//		}
		logger.debug("FSCORE-LOGD051");
		return new MappedParameter(request, request);
	}

}
