package com.small_it_office.flatserve.core.response;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletResponse;


import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.flatserve.core.process.internal.RequestContext;


/**
 * HTTP̉\NX̊NXłB
 * T[rX\bhÃNX̃TuNX̃IuWFNg߂lƂĕԂƁA
 * {@link #sendResponse()}\bhHTTP𐶐܂B
 * TuNXł́A{@link #getContentType()}HTTPcontent-typewb_肵A
 * {@link #writeResponse()}\bhŃX|XM̎s܂B
 */
public abstract class Response {

	/**
	 * X|XŕԋpHTTPXe[^XR[hB
	 * vOɂĐݒ肳Ȃꍇ0B
	 */
	private int statusCode;

	/**
	 * HTTPőMcontent-typewb_̒lԂ܂B
	 * @return content-typewb_̒l
	 */
	protected abstract String getContentType();

	/**
	 * HTTP݂܂B
	 * ̃\bh̓AvP[VĂяoƂ͂܂B
	 * <p>
	 * ޑOɉ炩̏Kvł΁Ã\bhōs܂B
	 * A{@link #setHeader(String, String)}\bhŐݒ肵HTTPwb_
	 * {@link #sendResponse()}\bhōŝŁAKv͂܂B
	 * ܂AHttpServletResponse#flushBuffer()ɂĂlɂ̃\bhōsKv͂܂B
	 * </p>
	 * @throws IOException ̏ݎIOG[ꍇ
	 */
	protected abstract void writeResponse() throws IOException;

	/**
	 * ɒǉHTTPwb_ێMapB
	 */
	private Map<String, String> headers = new HashMap<String, String>();

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * X|XŕԋpHTTPXe[^XR[h擾܂B
	 * @return X|XŕԋpHTTPXe[^XR[hBIɐݒ肳ĂȂꍇ0B
	 */
	public int getStatusCode() {
		return statusCode;
	}

	/**
	 * X|XŕԋpHTTPXe[^XR[hݒ肵܂B
	 * @param statusCode X|XŕԋpHTTPXe[^XR[hB
	 */
	public void setStatusCode(int statusCode) {
		this.statusCode = statusCode;
	}

	/**
	 * ɒǉHTTPwb_ݒ肵܂B
	 * @param name HTTPwb_
	 * @param value HTTPwb_̒l
	 */
	public void setHeader(String name, String value) {
		if (name != null) {
			name = name.toLowerCase();
		}
		headers.put(name, value);
	}

	/**
	 * ɒǉHTTPwb_̒l擾܂B
	 * @param name HTTPwb_
	 * @return value
	 */
	public String getHeader(String name) {
		if (name != null) {
			name = name.toLowerCase();
		}
		return headers.get(name);
	}

	/**
	 * ɒǉHTTPwb_AێĂ̂ɂđSĎ擾܂B
	 * @return ɒǉHTTPwb_ێMap
	 */
	public Map<String, String> getHeaders() {
		return headers;
	}

	/**
	 * HTTP𑗐M܂B
	 * ̃\bhFlatServeŎs܂BAvP[V͎sł܂B
	 * @throws IOException ̏ݎIOG[ꍇ
	 */
	public void sendResponse() throws IOException {
		logger.debug("FSCORE-LOGD057", this.getClass().getSimpleName());

		RequestContext context = RequestContext.get();
		HttpServletResponse response = context.getHttpServletResponse();

		if (statusCode != 0) {
			logger.debug("FSCORE-LOGD058", statusCode);
			response.setStatus(statusCode);
		}
		Set<String> headerNames = headers.keySet();
		for (String headerName : headerNames) {
			String value = headers.get(headerName);
			logger.debug("FSCORE-LOGD059", headerName, value);
			response.setHeader(headerName, value);
		}
		String contentType = getContentType();
		logger.debug("FSCORE-LOGD060", contentType);
		response.setContentType(contentType);

		writeResponse();
	}
}
