/*
 *  $Id: zy_table.c $
 */

/*
 * FreeWnn is a network-extensible Kana-to-Kanji conversion system.
 * This file is part of FreeWnn.
 * 
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright FreeWnn Project 1999, 2000
 *
 * Maintainer:  FreeWnn Project   <freewnn@tomo.gr.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**  cWnn  Version 1.1	 **/

#include  <ctype.h>
#include "commonhd.h"
#ifdef CHINESE
#include "cplib.h"

/* zy_shengmu_tbl: ShengMu table of Chinese ZhuYin  */
char 	*zy_shengmu_tbl[ZY_NUM_SHENGMU] = {
	
	"", "", "",  "", "",    /*	"", "B", "C",  "Ch", "D",   */
	"", "", "", "", "",    /*	"F", "G", "H",  "J",  "K", */
	"", "", "", "", "",    /*	"L", "M", "N",  "P",  "Q",  */
	"", "", "", "", "",    /*	"R", "S", "Sh", "T",  "W",  */
	"", "", "", ""          /*	"X", "Y", "Z",  "Zh"   */
	};
	

/* zy_yunmu_tbl: YunMu table of Chinese ZhuYin  */
char 	*zy_yunmu_tbl[ZY_NUM_YUNMU*5] = {
/* 3.20
	"",     "",     "",      "",      "", 
*/
	"",   "",   "",    "",    "",		/* a 	*/
	"ڎ",   "ڎ",   "ڎ",    "ڎ",    "ڎ",		/* a 	*/
	"ގ",   "ގ",   "ގ",    "ގ",    "ގ",		/* ai 	*/
	"",   "",   "",    "",    "",		/* an 	*/
	"",   "",   "",    "",    "",		/* ang 	*/
	"",   "",   "",    "",    "",		/* ao 	*/
	"܎",   "܎",   "܎",    "܎",    "܎",		/* e 	*/
	"ߎ",   "ߎ",   "ߎ",    "ߎ",    "ߎ",		/* ei 	*/
	"",   "",   "",    "",    "",		/* en 	*/
	"",   "",   "",    "",    "",		/* eng 	*/
	"",   "",   "",    "",    "",		/* er 	*/
	"",   "",   "",    "",    "",		/* i	*/
	"ڎ",  "ڎ",  "ڎ",   "ڎ",   "ڎ",	/* ia	*/
	"",  "",  "",   "",   "",	/* ian	*/
	"",  "",  "",   "",   "",	/* iang	*/
	"",  "",  "",   "",   "",	/* iao	*/
	"ݎ",  "ݎ",  "ݎ",   "ݎ",   "ݎ",	/* ie	*/
	"",  "",  "",   "",   "",	/* in	*/
	"",  "",  "",   "",   "",	/* ing	*/
	"",  "",  "",   "",   "",	/* iong	*/
	"",  "",  "",   "",   "",	/* iu	*/
	"ǎ",   "ǎ",   "ǎ",    "ǎ",    "ǎ",		/* m	*/
	"ˎ",   "ˎ",   "ˎ",    "ˎ",    "ˎ",		/* n 	*/
	"@",    "@",   "@",    "@",    "@",	/* ng	*/
	"ێ",   "ێ",   "ێ",    "ێ",    "ێ",		/* o 	*/
	"",  "",  "",   "",   "",	/* ong	*/
	"",   "",   "",    "",    "",		/* ou	*/
	"",   "",   "",    "",    "",		/* u	*/
	"ڎ",  "ڎ",  "ڎ",   "ڎ",   "ڎ",	/* ua	*/
	"ގ",  "ގ",  "ގ",   "ގ",   "ގ",	/* uai	*/
	"",  "",  "",   "",   "",	/* uan	*/
	"",  "",  "",   "",   "",	/* uang	*/
	"ݎ",  "ݎ",  "ݎ",   "ݎ",   "ݎ",	/* ue	*/
	"ߎ",  "ߎ",  "ߎ",   "ߎ",   "ߎ",	/* ui	*/
	"",  "",  "",   "",   "",	/* un 	*/
	"ێ",  "ێ",  "ێ",   "ێ",   "ێ",	/* uo	*/
	"",   "",   "",    "",    "",		/* 	*/
	"ݎ",  "ݎ",  "ݎ",   "ݎ",   "ݎ",	/* e	*/
	"0",    "1",    "2",     "3",     "4",	/* undefinited YunMu */
	"",  "",  "",   "",   "",	/* an,	only ZhuYin */
	"",  "",  "",   "",   "",	/* n,	only ZhuYin */
	};


/* zhuyin_tbl:  size is ZY_NUM_SHENGMU*ZY_NUM_YUNMU, including empty ShengMu */
/*      	empty YunMu and undefinited ShengMu '-' */

int  zhuyin_tbl[ZY_NUM_SHENGMU*ZY_NUM_YUNMU] = {
					    	
/* empty ShengMu */
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X8000,0X0000,0X0000,0X0000,0X0000,0X0000,0X9586,0X0000,0X9592,0X9599,
0X0000,0X8000,0X8000,0X8000,0X8000,0X0000,0X8000,0X0000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X959B,0X95A0,0X0000,0X959E,
0X95A2,

/* SHengMu B */
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X0000,0X8000,0X8000,0X8000,
0X0000,0X8000,0X0000,0X8000,0X0000,0X8000,0X8000,0X8000,0X8000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X8000,0X0000,0X0000,0X8000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu C */
0X828B,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X0000,0X0280,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,
0X8000,0X0000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu Ch */
0X838B,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X0000,0X8000,0X8000,
0X0000,0X0380,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X8000,0X8000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu D */
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X0000,0X8000,0X8000,0X8000,0X0000,0X8000,0X8000,0X0000,0X8000,0X0000,
0X8000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,
0X8000,0X0000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu F */
0X0000,0X8000,0X0000,0X8000,0X8000,0X0000,0X0000,0X8000,0X8000,0X8000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X8000,0X0000,0X8000,0X8000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu G */
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X8000,0X8000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu H */
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X8000,0X0000,0X8000,0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X8000,0X8000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu J */
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X8000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X08A4,0X0000,0X0000,
0X08A7,0X0000,0X08A5,0X0000,0X08A8,0X0000,0X889B,0X88A0,0X8000,0X889E,
0X88A2,

/* ShengMu K */
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X8000,0X8000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu L */
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X0000,0X8000,
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X0000,
0X8000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X8000,0X0000,0X0000,
0X8000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X0000,
0X0000,

/* ShengMu M */
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X0000,0X8000,0X0000,0X8000,0X0000,0X8000,0X8000,0X8000,0X8000,0X0000,
0X8000,0X0000,0X0000,0X0000,0X8000,0X0000,0X8000,0X8000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu N */
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X0000,0X8000,0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X0000,
0X8000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,
0X8000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X8000,0X0000,
0X0000,

/* ShengMu P */
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X0000,0X8000,0X8000,0X8000,
0X0000,0X8000,0X0000,0X8000,0X0000,0X8000,0X8000,0X8000,0X8000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X8000,0X0000,0X8000,0X8000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu Q */
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X8000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0EA4,0X0000,0X0000,
0X0EA7,0X0000,0X0EA5,0X0000,0X0EA8,0X0000,0X8E9B,0X8EA0,0X8000,0X8E9E,
0X8EA2,

/* ShengMu R */
0X8F8B,0X0000,0X0000,0X8000,0X8000,0X8000,0X8000,0X0000,0X8000,0X8000,
0X0000,0X0F80,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X8000,0X0000,
0X8000,0X0000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu S */
0X908B,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X0000,0X8000,0X8000,
0X0000,0X1080,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,
0X8000,0X0000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu Sh */
0X918B,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X0000,0X1180,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X8000,
0X8000,0X8000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu T */
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X0000,0X8000,
0X0000,0X8000,0X0000,0X8000,0X0000,0X8000,0X8000,0X0000,0X8000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,
0X8000,0X0000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu W */
0X939B,0X8000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X8000,0X8000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X8000,0X0000,0X0000,0X1380,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu X */
0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X8000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X14A4,0X0000,0X0000,
0X14A7,0X0000,0X14A5,0X0000,0X14A8,0X0000,0X949B,0X94A0,0X8000,0X949E,
0X94A2,

/* ShengMu Y */ 
0X958B,0X8000,0X0000,0X8000,0X8000,0X8000,0X0090,0X0000,0X9591,0X9592,
0X0000,0X1580,0X0000,0X0000,0X0000,0X0000,0X0000,0X1588,0X1589,0X0000,
0X0000,0X0000,0X0000,0X0000,0X8000,0X0093,0X8000,0X00A4,0X0000,0X0000,
0X00A7,0X0000,0X00A5,0X0000,0X00A8,0X0000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu Z */
0X968B,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X0000,0X1680,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,
0X8000,0X0000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X0000,
0X0000,

/* ShengMu Zh  */
0X978B,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X0000,0X1780,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,
0X0000,0X0000,0X0000,0X0000,0X0000,0X8000,0X8000,0X8000,0X8000,0X8000,
0X8000,0X8000,0X0000,0X8000,0X8000,0X8000,0X0000,0X0000,0X8000,0X0000,
0X0000,

	};
#endif /* CHINESE */
