.\"
.\"   $Id: ./cdicsort.man $
.\"

.\"
.\" FreeWnn is a network-extensible Kana-to-Kanji conversion system.
.\" This file is part of FreeWnn.
.\" 
.\" Copyright Kyoto University Research Institute for Mathematical Sciences
.\"                 1987, 1988, 1989, 1990, 1991, 1992
.\" Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
.\" Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
.\" Copyright FreeWnn Project 1999, 2000
.\" 
.\" Maintainer:  FreeWnn Project   <freewnn@tomo.gr.jp>
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
.\"

.TH CDICSORT \  "13 May 1992"
.SH NAME
cdicsort \- To sort the text format dictionary.
.SH SYNOPSIS
cdicsort  <   
.I textdic
.SH DEFAULT PATH
/usr/local/bin/cWnn4/cdicsort
.ad
.SH DESCRIPTION
This function allows user to sort the specified text format 
dictionary, which is piped in as 
.I textdic.
.sp 0
If the input text dictionary is not given, the input will be 
taken from the standard input(stdin).  
To end the input via standard input, press ^D.

"<" means to pipe the 
.I textdic 
as an input to "cdicsort" 
command.

.I textdic 
is the text format dictionary.  The format of 
this text file must be the same as that in the system text 
format dictionary.  That is,
.na
.sp 0
 --------------------------------------------------
.sp 0
|  Pinyin      Word       Cixing        Frequency  |
.sp 0
|   :           :          :              :        |
.sp 0
 --------------------------------------------------
.sp 0
.ad
Refer to cWnn manual for details.
.sp 0
By using "cdicsort", all the Pinyin tuples in  
.I textdic  
will be sorted.

The result of "cdicsort" will be output to standard output 
(stdout).  It may also be piped into a file by using the 
">" command.  For example,
.sp 0
     cdicsort  <  dict.u  >  sort_dict.u
.sp 0
"dict.u"  here is the input text format dictionary, while 
the "sort_dict.u" is the sorted text format dictionary.
