.\"
.\"   $Id: ./cdtoa.man $
.\"

.\"
.\" FreeWnn is a network-extensible Kana-to-Kanji conversion system.
.\" This file is part of FreeWnn.
.\" 
.\" Copyright Kyoto University Research Institute for Mathematical Sciences
.\"                 1987, 1988, 1989, 1990, 1991, 1992
.\" Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
.\" Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
.\" Copyright FreeWnn Project 1999, 2000
.\" 
.\" Maintainer:  FreeWnn Project   <freewnn@tomo.gr.jp>
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
.\"

.TH CDTOA \  "13 May 1992"
.SH NAME
cdtoa \- To convert the binary format of a dictionary back to
        text format.
.SH SYNOPSIS
cdtoa  [-n] [-s] [-z] [-e] [-E]  
.I infilename 
       [-h 
.I cixingfile
]  [
.I usagefreqfile
]
.SH DEFAULT PATH
/usr/local/bin/cWnn4/cdtoa
.ad
.SH DESCRIPTION
To convert the binary format of the dictionary to text 
.sp 0
format, and output to standard output(stdout).  

.I infilename 
is the name of the input binary format 
.sp 0
dictionary.

The output may be piped into a file by using the ">" 
.sp 0
command.  For example,
.sp 0
        cdtoa  dict.dic  >  dict.u
.sp 0
"dict.u" here is the output text format dictionary, while the "dict.dic" 
is the input binary format dictionary.

.I usagefreqfile
may indicate more than one user usage 
frequency files (for a particular user).  These usage frequency information 
will be reflected in the text format dictionary created. 
.SH OPTIONS
.IP -s 
To order the entries in text dictionary according to Pinyin or Zhuyin.
.IP -n
To attach sequence numbers to the output.
.IP -z
To convert the binary format back to text format in Zhuyin.  
.sp 0
(Note: default is Pinyin)
.IP -e
If the Hanzi inside the text dictionary contains characters such as space 
and tab, they will be compacted to special format. (Default)
.IP -E 
If the Hanzi inside the text dictionary contains characters such as space 
and tab, they will NOT be compacted to special format.
.IP -h 
.I cixingfile  
.sp 0
To specify the Cixing definition file.
.SH NOTE
.IP 1.
The parts in [ ] are options.  They may be omitted.
.IP 2.
The Pinyin and Zhuyin dictionary has the same format.
.IP 3.
The default conversion result of the text dictionary is in Pinyin.
