<?php

// (Shirai075): fs_moodleの設定を表示するメニューをサイト管理に追加 (2008/07/21)

require_once('../../../config.php');
require_once($CFG->libdir.'/fs_moodle/fs_status/lib.php');

page_header();

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

// (Shirai187): 電子メールでブログを投稿する機能 (2010/05/12)
function fsconfig_check_mail2blog_mailbox()
{
    global $CFG, $fsCFG;
    global $m2b;

    print_section_header('メールボックスの表示と操作');
    print_subsection_header('ログインチェック');
    echo '　メールサーバ(POP3)のアドレス：'.color_blue($fsCFG->m2b_host);
    newline();
    echo '　メールサーバのアカウント名：'.color_blue($fsCFG->m2b_user);
    newline();
    echo '　メールサーバのパスワード　：'.color_blue($fsCFG->m2b_pass);
    newline();
    echo '<hr />';
    newline();
    $loginresult = false;
    if (fs_mail2blog_enable(true)) {
        echo '　メールサーバへのログインに';
        if (($loginresult = $m2b->m2b_mail_login_check())) echo color_blue('成功しました').'．';
            else                                           echo color_red('失敗しました！');
    } else {
        echo color_red('　最低限の設定が完了していません！');
    }
    print_subsection_footer();

    print_subsection_header('受信メール一覧表示');
    if ($loginresult) {
        if (($maildata = $m2b->check_mail_only())) {
            $m2b->m2b_display_list($maildata);
            newline();
        } else {
            echo "　".color_blue('受信メールはありません')."．\n";
            newline();
        }
        echo '<form method="post" action="">';
        echo "　受信メール一覧を更新しますか？　\n";
        echo '<input type="hidden" name="action" value="none" />';
        echo '<input type="submit" value="更新">';
        echo '</form>';
        print_notice_message('警告', 'ブラウザの再読み込みボタンを押すと最後に実行されたコマンドを実行してしまいます．受信メール一覧を更新したい場合は「更新」ボタンを押して下さい．');
    } else {
        print_notice_message('注意', 'ログインできませんので，受信メールの一覧表示はできません．');
    }
    print_subsection_footer();

    print_subsection_header('受信メールの操作');
    echo "　手動操作によるブログの登録は認証がOKのメールのみ登録します．もし，登録と同時に削除を選択した場合，認証できなかったメールも同時に削除されますので気を付けて下さい．\n";
    newline();
    if ($loginresult) {
        if ($maildata) {
            echo '<form method="post" action="">';
            echo "　これらのメールを".color_red('全て削除しますか？')."　\n";
            echo '<input type="hidden" name="action" value="killall" />';
            echo '<input type="submit" value="全て削除">';
            echo '</form>';
            echo '<form method="post" action="">';
            echo "　これらのメールを全て手動でブログに登録しますか？".color_red('（メールを削除する）')."　\n";
            echo '<input type="hidden" name="action" value="blogupdateall" />';
            echo '<input type="hidden" name="deleteflag" value="1" />';
            echo '<input type="submit" value="全て登録">';
            echo '</form>';
            newline();
            print_notice_message('注意', '選択的に削除することはできません．このリストを表示した後に受信したメールも全て削除してしまいます．削除したメールは元に戻せません．');
            newline();
            echo '<hr />';
            echo '<form method="post" action="">';
            echo "　これらのメールを全て手動でブログに登録しますか？".color_blue('（メールを削除しない）')."　\n";
            echo '<input type="hidden" name="action" value="blogupdateall" />';
            echo '<input type="hidden" name="deleteflag" value="0" />';
            echo '<input type="submit" value="全て登録">';
            echo '</form>';
        } else {
            echo "　".color_blue('受信メールはありません')."．\n";
        }
    } else {
        print_notice_message('注意', 'ログインできませんので，受信メールの操作はできません．');
    }
    print_subsection_footer();
    print_subsection_header('cron.phpによる自動実行の操作');
    echo '　'.color_blue('admin/cron.php').'による受信メールのブログへの自動登録処理を停止することができます．';
    newline();
    echo '　現在，'.color_blue('cron.php').'による自動処理は';
    if (($time2stop = fs_mail2blog_is_cronstop())) {
        echo color_red('停止されています').'．再開は'.color_blue(strftime('%Y/%m/%d %H:%M:%S', $time2stop)).'以降，あと約'.((int)(($time2stop - time())/60)).'分後です．';
    } else {
        echo color_blue('停止されていません').'．';
    }
    echo '<hr />';
    echo '<form method="post" action="">';
    echo "　cron.phpによる自動処理を一時停止します．<br />";
    echo '<input type="hidden" name="action" value="cronstop" />';
//  echo '<input type="hidden" name="stoptime" value="1800" />';
    echo '　';
    echo '<input type="radio"  name="stoptime" value="900" />１５分後<br />';
    echo '　';
    echo '<input type="radio"  name="stoptime" value="1800" checked="checked"/>３０分後<br />';
    echo '　';
    echo '<input type="radio"  name="stoptime" value="3600" />１時間後<br />';
    echo '　';
    echo '<input type="radio"  name="stoptime" value="7200" />２時間後<br />';
    echo '　';
    echo '<input type="radio"  name="stoptime" value="86400" />２４時間後<br />';
    echo '　';
    echo '<input type="submit" value="実行">';
    echo '</form>';
    echo '<form method="post" action="">';
    echo "　cron.phpによる自動処理を再開します　\n";
    echo '<input type="hidden" name="action" value="cronstart" />';
    echo '<input type="submit" value="実行">';
    echo '</form>';
    print_subsection_footer();

    print_section_footer();
}

$m2b = new mail2blog();

// コマンド処理
$action     = optional_param('action', 'none', PARAM_RAW);
$deleteflag = optional_param('deleteflag', 0, PARAM_RAW);
$stoptime   = optional_param('stoptime', 0, PARAM_INT);
switch ($action) {
    case 'killall' :
        echo '全てのメールを削除します．';
        newline();
        if (($maildata = $m2b->check_mail_and_delete())) {
            $m2b->m2b_display_list($maildata);
            newline();
            echo "以上のメールを削除しました．\n";
            newline();
        } else {
            echo color_red('削除するメールがありませんでした．')."\n";
            newline();
        }
        break;
    case 'blogupdateall' :
        echo '全てのメールをブログに登録します．';
        if ($deleteflag) echo color_red('削除後にメールを全て削除します．');
        newline();
        if (($maildata = $m2b->check_mail_only())) {
            $m2b->m2b_display_list($maildata);
            newline();
            echo "以上のメールをブログに登録します．\n";
            newline();
            if (($result = $m2b->execute_mail2blog($deleteflag)) > 0) {
                echo "{$result}通の電子メールをブログとして登録しました．\n";
                newline();
            } else {
                echo color_red("残念ながら一つもブログは投稿されませんでした．")."\n";
                newline();
            }
            newline();
        } else {
            echo color_red('登録するメールがありませんでした．')."\n";
            newline();
        }
        break;
    case 'cronstop' :
        fs_mail2blog_cronstop($stoptime);
        break;
    case 'cronstart' :
        fs_mail2blog_cronstart();
        break;
    case 'none' :
        break;
    default :
        echo "未実装のコマンドです（{$action}）．";
        break;
}

fsconfig_check_mail2blog_mailbox();

// 戻るボタン
print_link2page('fsc_blog');

page_footer();

?>