<?php // (Shirai161): ブログをエクスポートする機能の追加 (2009/07/25)-

    require('../../../config.php');
//  require_once($CFG->libdir.'/formslib.php');

    $userid     = required_param('userid', PARAM_INT);
    $courseid   = optional_param('courseid', 0, PARAM_INT); // needed for user tabs and c

    if (!fs_function_enable('FS_ENABLE_BLOGEXPORT')) {
        error('Blog Export function is not enabled!');
    }

    require_login();
    // 権限のチェック
    if (!can_export_blog($userid)) {
        print_error('youcannotexporttheseblogs', 'fs_moodle');
    }

    if (empty($courseid)) {
        $courseid = SITEID;
    }
    if (!$course = fs_get_record('course', 'id', $courseid)) {
        error('The course number was incorrect ('. $courseid .')');
    }
// $sitecontext = get_context_instance(CONTEXT_SYSTEM);
    $coursecontext   = get_context_instance(CONTEXT_COURSE, $course->id);

    course_setup($courseid);

    if (!$user = fs_get_record('user', 'id', $userid)) {
       error('Wrong user id');
    }
    $navlinks = array();
    $strblogexport = get_string('blogexport', 'fs_moodle');
    $strparticipants   = get_string("participants");

    if ($course->id != SITEID && has_capability('moodle/course:viewparticipants', $coursecontext)) {
        $navlinks[] = array('name' => $strparticipants, 'link' => "{$CFG->wwwroot}/user/index.php?id=$course->id", 'type' => 'misc');
    }

    $navlinks[] = array('name' => fullname($user), 'link' => "{$CFG->wwwroot}/user/view.php?id=$user->id&amp;course=$course->id", 'type' => 'misc');
    $navlinks[] = array('name' => $strblogexport, 'link' => null, 'type' => 'misc');
//  $navlinks[] = array('name' => $strmode, 'link' => null, 'type' => 'misc');
    $navigation = build_navigation($navlinks);

    print_header("$course->shortname: $strblogexport", $course->fullname, $navigation);

//  require_capability('moodle/course:managefiles', get_context_instance(CONTEXT_COURSE, $course->id));

?>

<div class="course-content" align="center">

<br />
<?php print_string('startexportprocess', 'fs_moodle', fullname($user)) ?> <br />

<form method="POST" action="export.php" target="_blank">
  <table class="bextable" border="0" cellspacing="1" cellpading="10">
    <tr><th align="left">
    <?php print_string('selectexporttype', 'fs_moodle'); ?> <br />
    </th></tr>
    <tr><td align="left" nowrap>
    <input type="checkbox" name="singlehtml" value="1"  checked />&nbsp;<?php print_string('singlehtmltype', 'fs_moodle'); ?>
    <br />
    <input type="checkbox" name="tablehtml"  value="1"  checked />&nbsp;<?php print_string('tablehtmltype',  'fs_moodle'); ?> &nbsp;
    (&nbsp;<input type="checkbox" name="target_blank" value="1" />&nbsp;<?php print_string('istarget_blank', 'fs_moodle'); ?>&nbsp;)
    <br />
    <input type="checkbox" name="textdata"   value="1"  checked />&nbsp;<?php print_string('textdatatype',   'fs_moodle'); ?>
    <br />
<?php
//  <input type="checkbox" name="movabletype" value="1" checked />&nbsp;<?php print_string('movabletype',    'fs_moodle') <br />?>
    </td></tr>
    <tr><th align="left">
    <br />
    <?php print_string('selectsortorder', 'fs_moodle'); ?>
    </th></tr>
    <tr><td align="left">
    <input type="radio" name="descorder" value="1" checked />&nbsp; <?php print_string('sortdescend', 'fs_moodle'); ?>
    <br />
    <input type="radio" name="descorder" value="0"         />&nbsp; <?php print_string('sortascend',  'fs_moodle'); ?>
    <br />
    </td></tr>
    <tr><th align="left">
    <br />
    <?php print_string('selectidtype', 'fs_moodle'); ?>
    </th></tr>
    <tr><td align="left">
    <input type="radio" name="idnumber" value="1" checked />&nbsp; <?php print_string('blogpostid',   'fs_moodle'); ?>
    <br />
    <input type="radio" name="idnumber" value="0"         />&nbsp; <?php print_string('serialnumber', 'fs_moodle'); ?>
    <br />
    </td></tr>
    <tr><th align="left">
    <br />
    <?php print_string('selectfoldertypeofattachments', 'fs_moodle'); ?>
    </th></tr>
    <tr><td align="left">
    <input type="radio" name="attfolder" value="0" checked />&nbsp; <?php print_string('samefolder',      'fs_moodle'); ?>
    <br />
    <input type="radio" name="attfolder" value="1"         />&nbsp; <?php print_string('separatedfolder', 'fs_moodle'); ?>
    <br />
    </td></tr>
    <?php
        $now = usergetdate(time());
        $timestart = make_timestamp($now['year'], $now['mon'], $now['mday'], 0, 0, 0);
        $timeend = $timestart;
    ?>
    <tr><th align="left">
    <br />
    <?php print_string('selectfromdate', 'fs_moodle'); ?>
    </th></tr>
    <tr><td align="left">
    <input type="radio" name="enablestart" value="0" checked />&nbsp; <?php print_string('disable', 'fs_moodle'); ?>
    <br />
    <input type="radio" name="enablestart" value="1"         />&nbsp; <?php print_string('enable',  'fs_moodle'); ?>
    &nbsp; <?php print_date_selector('startday', 'startmon', 'startyr', $timestart);?>
    </td></tr>
    <tr><th align="left">
    <br />
    <?php print_string('selecttodate', 'fs_moodle'); ?>
    </th></tr>
    <tr><td align="left">
    <input type="radio" name="enableend" value="0" checked />&nbsp; <?php print_string('disable', 'fs_moodle'); ?>
    <br />
    <input type="radio" name="enableend" value="1"         />&nbsp; <?php print_string('enable',  'fs_moodle'); ?>
    &nbsp; <?php print_date_selector('endday', 'endmon', 'endyr', $timeend);?>
    </td></tr>
    <tr><th align="left">
    <br />
    <?php print_string('canchangeindexfname', 'fs_moodle'); ?>
    </th></tr>
    <tr><td align="left">
    <input type="text" name="indexfname" size="20" maxlength="20" value="index.html" />
    <br />
    </td></tr>
    <tr><th>
    <br />
    <input type="hidden" name="userid" value="<?php echo $userid; ?>" />
    <input type="submit" value="<?php echo $strblogexport; ?>" />
    <?php fs_helpbutton('blogexport', get_string('blogexport', 'fs_moodle'), 'fs_moodle', true, false, '', false); ?>
    </th></tr>
  </table>
</form>
<br />
<br />

<?php

    output_CloseWindowButton();

    print_footer($course);

?>
