<?php
// -----------------------------------------------
// オーバーライドするファイルシステム関係の関数群
// -----------------------------------------------

// (c1) bool chmod(str, int)
// (c2) bool copy(str, str)
// (e1) str escapeshellarg(str)
// (f1) array file(str, int, res)
// (f2) bool file_exists(str)
// (f3) str file_get_contents(str, bool, res, int, int)
// (f4) str file_put_contents(str, [, mix, int, res])
// (f5) int filectime(str)
// (f6) int filemtime(str)
// (f7) int filesize(str)
// (f8) str filetype(str)
// (f9) res fopen($fname, $mode)/2 のみ
// (g1) array getimagesize(str [, array])
// (i1) res imagecreatefromgif(str)
// (i2) res imagecreatefromjpg(str)
// (i3) res imagecreatefrompng(str)
// (i4) res imagecreatefromwbmp(str)
// (i5) res imagecreatefromxbm(str)
// (i6) res imagecreatefromxpm(str)
// (i7) bool imagegd($res [,$str])
// (i8) bool imagegd2($res [,$str])
// (i9) bool imagegif($res [,$str])
// (i10) bool imagejpeg($res [,$str [, int]])
// (i11) bool imagepng($res [,$str])
// (i12) bool imagewbmp($res [,$str [, int]])
// (i13) bool is_dir(str)
// (i14) bool is_executable(str)
// (i15) bool is_file(str)
// (i16) bool is_link(str)
// (i17) bool is_readable(str)
// (i18) bool is_uploaded_file(str)
// (i19) bool is_writable(str)
// (m1) str md5_file(str)
// (m2) bool mkdir(str, str)
// (m3) bool move_uploaded_file(str1, str2)
// (o1) res opendir(str)
// (r1) str readdir(res)
// (r2) int readfile(str)
// (r3) bool rename(str1, str2)
// (r4) bool rmdir(str [, int])
// (s1) array scandir(str [, int, res])
// (s2) str sha1_file(str, [bool])
// (s3) str shell_exec(str)
// (t1) bool touch(str [,int[, int]])
// (u1) int unlink(str,...)

// (c1) bool chmod(str, int)
    function fs_chmod($fname, $mode)
    {
        return chmod(currentCharset2fsCharset($fname), $mode);
    }

// (c2) bool copy(str, str)
    function fs_copy($from, $dest)
    {
        if (fs_function_enable('FS_ENABLE_MANIPULATEOVER2GBFILE')) {
            if (($fromsize = fs_filesize($from)) >= 2*1024*1024*1024) {
                $from = str_replace('/', '\\', $from);
                $dest = str_replace('/', '\\', $dest);
                $efrom = fs_escapeshellarg(currentCharset2fsCharset($from));
                $edest = fs_escapeshellarg(currentCharset2fsCharset($dest));
                $command = 'copy '.$efrom.' '.$edest;
                exec($command);
                // コピーできたか？
                if (!fs_file_exists($dest))          return false;
                // サイズは同じか？
                if (fs_filesize($dest) != $fromsize) return false;
                return true;
            }
        }
        return copy(currentCharset2fsCharset($from), currentCharset2fsCharset($dest));
    }

// (e1) str escapeshellarg(str)
    function fs_escapeshellarg($path)
    {
        if (strpos($path, ' ')) return "\"$path\"";
        if (strpos($path, '+')) return "\"$path\"";
        if (strpos($path, '&')) return "\"$path\"";
        return $path;
    }

// (f1) array file(str, int, res)
    function fs_file($filename, $path = false, $res = false)
    {
        if (!($path) && !($res)) return file(currentCharset2fsCharset($filename)); 
          else if (!$res) return file(currentCharset2fsCharset($filename), $path);
          else return file(currentCharset2fsCharset($filename), $path, $res);
    }

// (f2) bool file_exists(str)
    function fs_file_exists($str)
    {
        return file_exists(currentCharset2fsCharset($str));
    }

// (f3) str file_get_contents(str, bool, res, int, int)
    function fs_file_get_contents($filename, $path = false, $res = false, $offset = false, $maxbyte = false)
    {
        if (!($path) && !($res) && !($offset) && !($maxbyte)) return file_get_contents(currentCharset2fsCharset($filename));
          else if (!($res) && !($offset) && !($maxbyte)) return file_get_contents(currentCharset2fsCharset($filename), $path);
          else if (!($offset) && !($maxbyte)) return file_get_contents(currentCharset2fsCharset($filename), $path, $res);
          else if (!($maxbyte)) return file_get_contents(currentCharset2fsCharset($filename), $path, $res, $offset);
          else return file_get_contents(currentCharset2fsCharset($filename), $path, $res, $offset, $maxbyte);
    }

// (f4) str file_put_contents(str, [, mix, int, res])
    function fs_file_put_contents($filename, $contents, $flag = false, $res = false)
    {
        if (!($flag) && !($res)) return file_put_contents(currentCharset2fsCharset($filename), $contents);
          else if (!($res)) return file_put_contents(currentCharset2fsCharset($filename), $contents, $flag);
          else return file_put_contents(currentCharset2fsCharset($filename), $contents, $flag, $rees);
    }

// (f5) int filemtime(str): 新文字コードでファイルが実在しない場合は旧文字コードで探してみる
//     $fnameの中のパスが新旧の文字コード混在の場合はfalseとなる（仕方ない）
    function fs_filectime($fname)
    {
        if (is_file(currentCharset2fsCharset($fname)) || is_dir(currentCharset2fsCharset($fname))) {
            return filectime(currentCharset2fsCharset($fname));
        }
        if (is_file(currentCharset2fsCharset($fname, true)) || is_dir(currentCharset2fsCharset($fname, true))) {
            return filectime(currentCharset2fsCharset($fname, true));
        }
        return false;
    }

// (f6) int filemtime(str): 新文字コードでファイルが実在しない場合は旧文字コードで探してみる
//     $fnameの中のパスが新旧の文字コード混在の場合はfalseとなる（仕方ない）
    function fs_filemtime($fname)
    {
        if (is_file(currentCharset2fsCharset($fname)) || is_dir(currentCharset2fsCharset($fname))) {
            return filemtime(currentCharset2fsCharset($fname));
        }
        if (is_file(currentCharset2fsCharset($fname, true)) || is_dir(currentCharset2fsCharset($fname, true))) {
            return filemtime(currentCharset2fsCharset($fname, true));
        }
        return false;
    }

// (f7) int filesize(str) : 新文字コードでファイルが実在しない場合は旧文字コードで探してみる
//     $fnameの中のパスが新旧の文字コード混在の場合はfalseとなる（仕方ない）
    function fs_filesize($fname)
    {
        if (is_file(currentCharset2fsCharset($fname))) $fname = currentCharset2fsCharset($fname);
          else if (is_file(currentCharset2fsCharset($fname, true))) $fname = currentCharset2fsCharset($fname, true);
          else return false;

        if (fs_function_enable('FS_ENABLE_MANIPULATEOVER2GBFILE')) {
            $size = exec('stat -c %s "'.$fname.'"');
            return $size;
        }
        return sprintf("%u", filesize($fname));
    }

// (f8) str filetype(str) : error時はFALSE
//     新文字コードでファイルが実在しない場合は旧文字コードで探してみる
    function fs_filetype($fname)
    {
        if (is_file(currentCharset2fsCharset($fname)) || is_dir(currentCharset2fsCharset($fname))) {
            return filetype(currentCharset2fsCharset($fname));
        }
        if (is_file(currentCharset2fsCharset($fname, true)) || is_dir(currentCharset2fsCharset($fname, true))) {
            return filetype(currentCharset2fsCharset($fname, true));
        }
        return false;
    }

// (f9) res fopen($fname, $mode)/2 のみ
    function fs_fopen($fname, $mode)
    {
        return fopen(currentCharset2fsCharset($fname), $mode);
    }

// (g1) array getimagesize(str [, array])
    function fs_getimagesize($fname, &$imageinfo = false)
    {
        if (!$imageinfo) return getimagesize(currentCharset2fsCharset($fname));
        return getimagesize(currentCharset2fsCharset($fname), $imageinfo);
    }

// (i1) res imagecreatefromgif(str)
    function fs_imagecreatefromgif($fname)
    {
        return imagecreatefromgif(currentCharset2fsCharset($fname));
    }
// (i2) res imagecreatefromjpeg(str)
    function fs_imagecreatefromjpeg($fname)
    {
        return imagecreatefromjpeg(currentCharset2fsCharset($fname));
    }
// (i3) res imagecreatefrompng(str)
    function fs_imagecreatefrompng($fname)
    {
        return imagecreatefrompng(currentCharset2fsCharset($fname));
    }
// (i4) res imagecreatefromwbmp(str)
    function fs_imagecreatefromwbmp($fname)
    {
        return imagecreatefromwbmp(currentCharset2fsCharset($fname));
    }
// (i5) res imagecreatefromxbm(str)
    function fs_imagecreatefromxbm($fname)
    {
        return imagecreatefromxbm(currentCharset2fsCharset($fname));
    }
// (i6) res imagecreatefromxpm(str)
    function fs_imagecreatefromxpm($fname)
    {
        return imagecreatefromxpm(currentCharset2fsCharset($fname));
    }
// (i7) bool imagegd($res [,$str])
    function fs_imagegd($image, $fname = false)
    {
        if ($fname === false) return imagegd($image);
        return imagegd($image, currentCharset2fsCharset($fname));
    }
// (i8) bool imagegd2($res [,$str])
    function fs_imagegd2($image, $fname = false)
    {
        if ($fname === false) return imagegd2($image);
        return imagegd2($image, currentCharset2fsCharset($fname));
    }
// (i9) bool imagegif($res [,$str])
    function fs_imagegif($image, $fname = false)
    {
        if ($fname === false) return imagegif($image);
        return imagegif($image, currentCharset2fsCharset($fname));
    }
// (i10) bool imagejpeg($res [,$str [, int]])
    function fs_imagejpeg($image, $fname = false, $quality = false)
    {
        if ($quality !== false)         return imagejpeg($image, currentCharset2fsCharset($fname), $quality);
            else if ($fname !== false)  return imagejpeg($image, currentCharset2fsCharset($fname));
        return imagejpeg($image);
    }
// (i11) bool imagepng($res [,$str])
    function fs_imagepng($image, $fname = false)
    {
        if ($fname === false) return imagepng($image);
        return imagepng($image, currentCharset2fsCharset($fname));
    }
// (i12) bool imagewbmp($res [,$str [, int]])
    function fs_imagewbmp($image, $fname = false, $fcol = false)
    {
        if ($fcol !== false)            return imagewbmp($image, currentCharset2fsCharset($fname), $fcol);
            else if ($fname !== false)  return imagewbmp($image, currentCharset2fsCharset($fname));
        return imagewbmp($image);
    }

// (i13) bool is_dir(str)
    function fs_is_dir($str)
    {
        return is_dir(currentCharset2fsCharset($str));
    }

// (i14) bool is_executable(str)
    function fs_is_executable($fname)
    {
        return is_executable(currentCharset2fsCharset($fname));
    }

// (i15) bool is_file(str)
    function fs_is_file($str)
    {
        return is_file(currentCharset2fsCharset($str));
    }

// (i16) bool is_link(str)
    function fs_is_link($str)
    {
        return is_link(currentCharset2fsCharset($str));
    }

// (i17) bool is_readable(str)
    function fs_is_readable($fname)
    {
        return is_readable(currentCharset2fsCharset($fname));
    }

// (i18) bool is_uploaded_file(str)
    function fs_is_uploaded_file($str)
    {
        return is_uploaded_file(currentCharset2fsCharset($str));
    }

// (i19) bool is_writable(str)
    function fs_is_writable($fname)
    {
        return is_writable(currentCharset2fsCharset($fname));
    }

// (m1) str md5_file(str)
    function fs_md5_file($fname)
    {
        return md5_file(currentCharset2fsCharset($fname));
    }

// (m2) bool mkdir(str, str)
    function fs_mkdir($dirname, $mode = false, $recursive = false)
    {
        // Windows版PHPでは$modeは無視される（しかし指定しないとWarningが発生する）
        if (!$mode && $recursive) return mkdir(currentCharset2fsCharset($dirname));
        if (!$recursive) return mkdir(currentCharset2fsCharset($dirname), $mode);
        return mkdir(currentCharset2fsCharset($dirname), $mode, $recursive);
    }

// (m3) bool move_uploaded_file(str1, str2): str1->str2
    function fs_move_uploaded_file($str1, $str2)
    {
        return move_uploaded_file(currentCharset2fsCharset($str1), currentCharset2fsCharset($str2));
    }

// (o1) res opendir(str)
    function fs_opendir($dirname)
    {
        return opendir(currentCharset2fsCharset($dirname));
    }

// (r1) str readdir(res)
    function fs_readdir($res)
    {
        if (($ret = readdir($res)) === false) return false;
        return fsCharset2currentCharset($ret);
    }

// (r2) int readfile(str)
    function fs_readfile($fname, $path = false, $stream = false)
    {
        if (!$path && !$stream) return readfile(currentCharset2fsCharset($fname));
        if (!$stream)           return readfile(currentCharset2fsCharset($fname), $path);
        return readfile(currentCharset2fsCharset($fname), $path, $stream);
    }

// (r3) bool rename(str1, str2) : str1 -> str2
    function fs_rename($str1, $str2)
    {
        return rename(currentCharset2fsCharset($str1), currentCharset2fsCharset($str2));
    }

// (r4) bool rmdir(str [, int])
    function fs_rmdir($dirname, $accmode = false)
    {
        if (!$accmode) return rmdir(currentCharset2fsCharset($dirname));
        return rmdir(currentCharset2fsCharset($dirname), $accmode);
    }

// (s1) array scandir(str [, int, res])
    function fs_scandir($directory, $order = false, $context = false)
    {
        if (!$order && !$context)   $ret = scandir(currentCharset2fsCharset($directory));
            else if (!$context)     $ret = scandir(currentCharset2fsCharset($directory), $order);
            else $ret = scandir(currentCharset2fsCharset($directory), $order, $context);
        return (fsCharset2currentCharset_array($ret));
    }

// (s2) str sha1_file(str, [bool])
    function fs_sha1_file($filename, $binary = false)
    {
        return sha1_file(currentCharset2fsCharset($filename), $binary);
    }

// (s3) str shell_exec(str)
    function fs_shell_exec($cmd, $noconv = false)
    {
        if (empty($cmd)) return false;
        $ret = shell_exec(currentCharset2fsCharset($cmd));
        if ($noconv) return $ret;
        return fsCharset2currentCharset($ret);
    }

// (t1) bool touch(str [,int[, int]])
    function fs_touch($fname, $utime = false, $atime = false)
    {
        if ($atime !== false)          return touch(currentCharset2fsCharset($fname), $utime, $atime);
            else if ($utime !== false) return touch(currentCharset2fsCharset($fname), $utime);
        return touch(currentCharset2fsCharset($fname));
    }

// (u1) int unlink(str,...)
    function fs_unlink($fname)
    {
        return unlink(currentCharset2fsCharset($fname));
    }

?>