/*
YUI 3.7.3 (build 5687)
Copyright 2012 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/
if (typeof _yuitest_coverage == "undefined"){
    _yuitest_coverage = {};
    _yuitest_coverline = function(src, line){
        var coverage = _yuitest_coverage[src];
        if (!coverage.lines[line]){
            coverage.calledLines++;
        }
        coverage.lines[line]++;
    };
    _yuitest_coverfunc = function(src, name, line){
        var coverage = _yuitest_coverage[src],
            funcId = name + ":" + line;
        if (!coverage.functions[funcId]){
            coverage.calledFunctions++;
        }
        coverage.functions[funcId]++;
    };
}
_yuitest_coverage["build/datatable-body/datatable-body.js"] = {
    lines: {},
    functions: {},
    coveredLines: 0,
    calledLines: 0,
    coveredFunctions: 0,
    calledFunctions: 0,
    path: "build/datatable-body/datatable-body.js",
    code: []
};
_yuitest_coverage["build/datatable-body/datatable-body.js"].code=["YUI.add('datatable-body', function (Y, NAME) {","","/**","View class responsible for rendering the `<tbody>` section of a table. Used as","the default `bodyView` for `Y.DataTable.Base` and `Y.DataTable` classes.","","@module datatable","@submodule datatable-body","@since 3.5.0","**/","var Lang         = Y.Lang,","    isArray      = Lang.isArray,","    isNumber     = Lang.isNumber,","    isString     = Lang.isString,","    fromTemplate = Lang.sub,","    htmlEscape   = Y.Escape.html,","    toArray      = Y.Array,","    bind         = Y.bind,","    YObject      = Y.Object;","","/**","View class responsible for rendering the `<tbody>` section of a table. Used as","the default `bodyView` for `Y.DataTable.Base` and `Y.DataTable` classes.","","Translates the provided `modelList` into a rendered `<tbody>` based on the data","in the constituent Models, altered or ammended by any special column","configurations.","","The `columns` configuration, passed to the constructor, determines which","columns will be rendered.","","The rendering process involves constructing an HTML template for a complete row","of data, built by concatenating a customized copy of the instance's","`CELL_TEMPLATE` into the `ROW_TEMPLATE` once for each column.  This template is","then populated with values from each Model in the `modelList`, aggregating a","complete HTML string of all row and column data.  A `<tbody>` Node is then created from the markup and any column `nodeFormatter`s are applied.","","Supported properties of the column objects include:","","  * `key` - Used to link a column to an attribute in a Model.","  * `name` - Used for columns that don't relate to an attribute in the Model","    (`formatter` or `nodeFormatter` only) if the implementer wants a","    predictable name to refer to in their CSS.","  * `cellTemplate` - Overrides the instance's `CELL_TEMPLATE` for cells in this","    column only.","  * `formatter` - Used to customize or override the content value from the","    Model.  These do not have access to the cell or row Nodes and should","    return string (HTML) content.","  * `nodeFormatter` - Used to provide content for a cell as well as perform any","    custom modifications on the cell or row Node that could not be performed by","    `formatter`s.  Should be used sparingly for better performance.","  * `emptyCellValue` - String (HTML) value to use if the Model data for a","    column, or the content generated by a `formatter`, is the empty string,","    `null`, or `undefined`.","  * `allowHTML` - Set to `true` if a column value, `formatter`, or","    `emptyCellValue` can contain HTML.  This defaults to `false` to protect","    against XSS.","  * `className` - Space delimited CSS classes to add to all `<td>`s in a column.","","Column `formatter`s are passed an object (`o`) with the following properties:","","  * `value` - The current value of the column's associated attribute, if any.","  * `data` - An object map of Model keys to their current values.","  * `record` - The Model instance.","  * `column` - The column configuration object for the current column.","  * `className` - Initially empty string to allow `formatter`s to add CSS ","    classes to the cell's `<td>`.","  * `rowIndex` - The zero-based row number.","  * `rowClass` - Initially empty string to allow `formatter`s to add CSS","    classes to the cell's containing row `<tr>`.","","They may return a value or update `o.value` to assign specific HTML content.  A","returned value has higher precedence.","","Column `nodeFormatter`s are passed an object (`o`) with the following","properties:","","  * `value` - The current value of the column's associated attribute, if any.","  * `td` - The `<td>` Node instance.","  * `cell` - The `<div>` liner Node instance if present, otherwise, the `<td>`.","    When adding content to the cell, prefer appending into this property.","  * `data` - An object map of Model keys to their current values.","  * `record` - The Model instance.","  * `column` - The column configuration object for the current column.","  * `rowIndex` - The zero-based row number.","","They are expected to inject content into the cell's Node directly, including","any \"empty\" cell content.  Each `nodeFormatter` will have access through the","Node API to all cells and rows in the `<tbody>`, but not to the `<table>`, as","it will not be attached yet.","","If a `nodeFormatter` returns `false`, the `o.td` and `o.cell` Nodes will be","`destroy()`ed to remove them from the Node cache and free up memory.  The DOM","elements will remain as will any content added to them.  _It is highly","advisable to always return `false` from your `nodeFormatter`s_.","","@class BodyView","@namespace DataTable","@extends View","@since 3.5.0","**/","Y.namespace('DataTable').BodyView = Y.Base.create('tableBody', Y.View, [], {","    // -- Instance properties -------------------------------------------------","","    /**","    HTML template used to create table cells.","","    @property CELL_TEMPLATE","    @type {HTML}","    @default '<td {headers} class=\"{className}\">{content}</td>'","    @since 3.5.0","    **/","    CELL_TEMPLATE: '<td {headers} class=\"{className}\">{content}</td>',","","    /**","    CSS class applied to even rows.  This is assigned at instantiation.","    ","    For DataTable, this will be `yui3-datatable-even`.","","    @property CLASS_EVEN","    @type {String}","    @default 'yui3-table-even'","    @since 3.5.0","    **/","    //CLASS_EVEN: null","","    /**","    CSS class applied to odd rows.  This is assigned at instantiation.","    ","    When used by DataTable instances, this will be `yui3-datatable-odd`.","","    @property CLASS_ODD","    @type {String}","    @default 'yui3-table-odd'","    @since 3.5.0","    **/","    //CLASS_ODD: null","","    /**","    HTML template used to create table rows.","","    @property ROW_TEMPLATE","    @type {HTML}","    @default '<tr id=\"{rowId}\" data-yui3-record=\"{clientId}\" class=\"{rowClass}\">{content}</tr>'","    @since 3.5.0","    **/","    ROW_TEMPLATE : '<tr id=\"{rowId}\" data-yui3-record=\"{clientId}\" class=\"{rowClass}\">{content}</tr>',","","    /**","    The object that serves as the source of truth for column and row data.","    This property is assigned at instantiation from the `host` property of","    the configuration object passed to the constructor.","","    @property host","    @type {Object}","    @default (initially unset)","    @since 3.5.0","    **/","    //TODO: should this be protected?","    //host: null,","","    /**","    HTML templates used to create the `<tbody>` containing the table rows.","","    @property TBODY_TEMPLATE","    @type {HTML}","    @default '<tbody class=\"{className}\">{content}</tbody>'","    @since 3.6.0","    **/","    TBODY_TEMPLATE: '<tbody class=\"{className}\"></tbody>',","","    // -- Public methods ------------------------------------------------------","","    /**","    Returns the `<td>` Node from the given row and column index.  Alternately,","    the `seed` can be a Node.  If so, the nearest ancestor cell is returned.","    If the `seed` is a cell, it is returned.  If there is no cell at the given","    coordinates, `null` is returned.","","    Optionally, include an offset array or string to return a cell near the","    cell identified by the `seed`.  The offset can be an array containing the","    number of rows to shift followed by the number of columns to shift, or one","    of \"above\", \"below\", \"next\", or \"previous\".","","    <pre><code>// Previous cell in the previous row","    var cell = table.getCell(e.target, [-1, -1]);","","    // Next cell","    var cell = table.getCell(e.target, 'next');","    var cell = table.getCell(e.taregt, [0, 1];</pre></code>","","    @method getCell","    @param {Number[]|Node} seed Array of row and column indexes, or a Node that","        is either the cell itself or a descendant of one.","    @param {Number[]|String} [shift] Offset by which to identify the returned","        cell Node","    @return {Node}","    @since 3.5.0","    **/","    getCell: function (seed, shift) {","        var tbody = this.tbodyNode,","            row, cell, index, rowIndexOffset;","","        if (seed && tbody) {","            if (isArray(seed)) {","                row = tbody.get('children').item(seed[0]);","                cell = row && row.get('children').item(seed[1]);","            } else if (Y.instanceOf(seed, Y.Node)) {","                cell = seed.ancestor('.' + this.getClassName('cell'), true);","            }","","            if (cell && shift) {","                rowIndexOffset = tbody.get('firstChild.rowIndex');","                if (isString(shift)) {","                    // TODO this should be a static object map","                    switch (shift) {","                        case 'above'   : shift = [-1, 0]; break;","                        case 'below'   : shift = [1, 0]; break;","                        case 'next'    : shift = [0, 1]; break;","                        case 'previous': shift = [0, -1]; break;","                    }","                }","","                if (isArray(shift)) {","                    index = cell.get('parentNode.rowIndex') +","                                shift[0] - rowIndexOffset;","                    row   = tbody.get('children').item(index);","","                    index = cell.get('cellIndex') + shift[1];","                    cell  = row && row.get('children').item(index);","                }","            }","        }","        ","        return cell || null;","    },","","    /**","    Returns the generated CSS classname based on the input.  If the `host`","    attribute is configured, it will attempt to relay to its `getClassName`","    or use its static `NAME` property as a string base.","    ","    If `host` is absent or has neither method nor `NAME`, a CSS classname","    will be generated using this class's `NAME`.","","    @method getClassName","    @param {String} token* Any number of token strings to assemble the","        classname from.","    @return {String}","    @protected","    @since 3.5.0","    **/","    getClassName: function () {","        var host = this.host,","            args;","","        if (host && host.getClassName) {","            return host.getClassName.apply(host, arguments);","        } else {","            args = toArray(arguments);","            args.unshift(this.constructor.NAME);","            return Y.ClassNameManager.getClassName","                .apply(Y.ClassNameManager, args);","        }","    },","","    /**","    Returns the Model associated to the row Node or id provided. Passing the","    Node or id for a descendant of the row also works.","","    If no Model can be found, `null` is returned.","","    @method getRecord","    @param {String|Node} seed Row Node or `id`, or one for a descendant of a row","    @return {Model}","    @since 3.5.0","    **/","    getRecord: function (seed) {","        var modelList = this.get('modelList'),","            tbody     = this.tbodyNode,","            row       = null,","            record;","","        if (tbody) {","            if (isString(seed)) {","                seed = tbody.one('#' + seed);","            }","","            if (Y.instanceOf(seed, Y.Node)) {","                row = seed.ancestor(function (node) {","                    return node.get('parentNode').compareTo(tbody);","                }, true);","","                record = row &&","                    modelList.getByClientId(row.getData('yui3-record'));","            }","        }","","        return record || null;","    },","","    /**","    Returns the `<tr>` Node from the given row index, Model, or Model's","    `clientId`.  If the rows haven't been rendered yet, or if the row can't be","    found by the input, `null` is returned.","","    @method getRow","    @param {Number|String|Model} id Row index, Model instance, or clientId","    @return {Node}","    @since 3.5.0","    **/","    getRow: function (id) {","        var tbody = this.tbodyNode,","            row = null;","","        if (tbody) {","            if (id) {","                id = this._idMap[id.get ? id.get('clientId') : id] || id;","            }","","            row = isNumber(id) ?","                tbody.get('children').item(id) :","                tbody.one('#' + id);","        }","","        return row;","    },","","    /**","    Creates the table's `<tbody>` content by assembling markup generated by","    populating the `ROW\\_TEMPLATE`, and `CELL\\_TEMPLATE` templates with content","    from the `columns` and `modelList` attributes.","","    The rendering process happens in three stages:","","    1. A row template is assembled from the `columns` attribute (see","       `_createRowTemplate`)","","    2. An HTML string is built up by concatening the application of the data in","       each Model in the `modelList` to the row template. For cells with","       `formatter`s, the function is called to generate cell content. Cells","       with `nodeFormatter`s are ignored. For all other cells, the data value","       from the Model attribute for the given column key is used.  The","       accumulated row markup is then inserted into the container.","","    3. If any column is configured with a `nodeFormatter`, the `modelList` is","       iterated again to apply the `nodeFormatter`s.","","    Supported properties of the column objects include:","","      * `key` - Used to link a column to an attribute in a Model.","      * `name` - Used for columns that don't relate to an attribute in the Model","        (`formatter` or `nodeFormatter` only) if the implementer wants a","        predictable name to refer to in their CSS.","      * `cellTemplate` - Overrides the instance's `CELL_TEMPLATE` for cells in","        this column only.","      * `formatter` - Used to customize or override the content value from the","        Model.  These do not have access to the cell or row Nodes and should","        return string (HTML) content.","      * `nodeFormatter` - Used to provide content for a cell as well as perform","        any custom modifications on the cell or row Node that could not be","        performed by `formatter`s.  Should be used sparingly for better","        performance.","      * `emptyCellValue` - String (HTML) value to use if the Model data for a","        column, or the content generated by a `formatter`, is the empty string,","        `null`, or `undefined`.","      * `allowHTML` - Set to `true` if a column value, `formatter`, or","        `emptyCellValue` can contain HTML.  This defaults to `false` to protect","        against XSS.","      * `className` - Space delimited CSS classes to add to all `<td>`s in a","        column.","","    Column `formatter`s are passed an object (`o`) with the following","    properties:","","      * `value` - The current value of the column's associated attribute, if","        any.","      * `data` - An object map of Model keys to their current values.","      * `record` - The Model instance.","      * `column` - The column configuration object for the current column.","      * `className` - Initially empty string to allow `formatter`s to add CSS ","        classes to the cell's `<td>`.","      * `rowIndex` - The zero-based row number.","      * `rowClass` - Initially empty string to allow `formatter`s to add CSS","        classes to the cell's containing row `<tr>`.","","    They may return a value or update `o.value` to assign specific HTML","    content.  A returned value has higher precedence.","","    Column `nodeFormatter`s are passed an object (`o`) with the following","    properties:","","      * `value` - The current value of the column's associated attribute, if","        any.","      * `td` - The `<td>` Node instance.","      * `cell` - The `<div>` liner Node instance if present, otherwise, the","        `<td>`.  When adding content to the cell, prefer appending into this","        property.","      * `data` - An object map of Model keys to their current values.","      * `record` - The Model instance.","      * `column` - The column configuration object for the current column.","      * `rowIndex` - The zero-based row number.","","    They are expected to inject content into the cell's Node directly, including","    any \"empty\" cell content.  Each `nodeFormatter` will have access through the","    Node API to all cells and rows in the `<tbody>`, but not to the `<table>`,","    as it will not be attached yet.","","    If a `nodeFormatter` returns `false`, the `o.td` and `o.cell` Nodes will be","    `destroy()`ed to remove them from the Node cache and free up memory.  The","    DOM elements will remain as will any content added to them.  _It is highly","    advisable to always return `false` from your `nodeFormatter`s_.","","    @method render","    @return {BodyView} The instance","    @chainable","    @since 3.5.0","    **/","    render: function () {","        var table   = this.get('container'),","            data    = this.get('modelList'),","            columns = this.get('columns'),","            tbody   = this.tbodyNode ||","                      (this.tbodyNode = this._createTBodyNode());","        ","        // Needed for mutation","        this._createRowTemplate(columns);","","        if (data) {","            tbody.setHTML(this._createDataHTML(columns));","","            this._applyNodeFormatters(tbody, columns);","        }","","        if (tbody.get('parentNode') !== table) {","            table.appendChild(tbody);","        }","","        this.bindUI();","","        return this;","    },","","    // -- Protected and private methods ---------------------------------------","    /**","    Handles changes in the source's columns attribute.  Redraws the table data.","","    @method _afterColumnsChange","    @param {EventFacade} e The `columnsChange` event object","    @protected","    @since 3.5.0","    **/","    // TODO: Preserve existing DOM","    // This will involve parsing and comparing the old and new column configs","    // and reacting to four types of changes:","    // 1. formatter, nodeFormatter, emptyCellValue changes","    // 2. column deletions","    // 3. column additions","    // 4. column moves (preserve cells)","    _afterColumnsChange: function (e) {","        this.render();","    },","","    /**","    Handles modelList changes, including additions, deletions, and updates.","","    Modifies the existing table DOM accordingly.","","    @method _afterDataChange","    @param {EventFacade} e The `change` event from the ModelList","    @protected","    @since 3.5.0","    **/","    _afterDataChange: function (e) {","        //var type = e.type.slice(e.type.lastIndexOf(':') + 1);","","        // TODO: Isolate changes","        this.render();","    },","","    /**","    Handles replacement of the modelList.","","    Rerenders the `<tbody>` contents.","","    @method _afterModelListChange","    @param {EventFacade} e The `modelListChange` event","    @protected","    @since 3.6.0","    **/","    _afterModelListChange: function (e) {","        var handles = this._eventHandles;","","        if (handles.dataChange) {","            handles.dataChange.detach();","            delete handles.dataChange;","            this.bindUI();","        }","","        if (this.tbodyNode) {","            this.render();","        }","    },","","    /**","    Iterates the `modelList`, and calls any `nodeFormatter`s found in the","    `columns` param on the appropriate cell Nodes in the `tbody`.","","    @method _applyNodeFormatters","    @param {Node} tbody The `<tbody>` Node whose columns to update","    @param {Object[]} columns The column configurations","    @protected","    @since 3.5.0","    **/","    _applyNodeFormatters: function (tbody, columns) {","        var host = this.host,","            data = this.get('modelList'),","            formatters = [],","            linerQuery = '.' + this.getClassName('liner'),","            rows, i, len;","","        // Only iterate the ModelList again if there are nodeFormatters","        for (i = 0, len = columns.length; i < len; ++i) {","            if (columns[i].nodeFormatter) {","                formatters.push(i);","            }","        }","","        if (data && formatters.length) {","            rows = tbody.get('childNodes');","","            data.each(function (record, index) {","                var formatterData = {","                        data      : record.toJSON(),","                        record    : record,","                        rowIndex  : index","                    },","                    row = rows.item(index),","                    i, len, col, key, cells, cell, keep;","","","                if (row) {","                    cells = row.get('childNodes');","                    for (i = 0, len = formatters.length; i < len; ++i) {","                        cell = cells.item(formatters[i]);","","                        if (cell) {","                            col = formatterData.column = columns[formatters[i]];","                            key = col.key || col.id;","","                            formatterData.value = record.get(key);","                            formatterData.td    = cell;","                            formatterData.cell  = cell.one(linerQuery) || cell;","","                            keep = col.nodeFormatter.call(host,formatterData);","","                            if (keep === false) {","                                // Remove from the Node cache to reduce","                                // memory footprint.  This also purges events,","                                // which you shouldn't be scoping to a cell","                                // anyway.  You've been warned.  Incidentally,","                                // you should always return false. Just sayin.","                                cell.destroy(true);","                            }","                        }","                    }","                }","            });","        }","    },","","    /**","    Binds event subscriptions from the UI and the host (if assigned).","","    @method bindUI","    @protected","    @since 3.5.0","    **/","    bindUI: function () {","        var handles     = this._eventHandles,","            modelList   = this.get('modelList'),","            changeEvent = modelList.model.NAME + ':change';","","        if (!handles.columnsChange) {","            handles.columnsChange = this.after('columnsChange',","                bind('_afterColumnsChange', this));","        }","","        if (modelList && !handles.dataChange) {","            handles.dataChange = modelList.after(","                ['add', 'remove', 'reset', changeEvent],","                bind('_afterDataChange', this));","        }","    },","","    /**","    Iterates the `modelList` and applies each Model to the `_rowTemplate`,","    allowing any column `formatter` or `emptyCellValue` to override cell","    content for the appropriate column.  The aggregated HTML string is","    returned.","","    @method _createDataHTML","    @param {Object[]} columns The column configurations to customize the","                generated cell content or class names","    @return {HTML} The markup for all Models in the `modelList`, each applied","                to the `_rowTemplate`","    @protected","    @since 3.5.0","    **/","    _createDataHTML: function (columns) {","        var data = this.get('modelList'),","            html = '';","","        if (data) {","            data.each(function (model, index) {","                html += this._createRowHTML(model, index, columns);","            }, this);","        }","","        return html;","    },","","    /**","    Applies the data of a given Model, modified by any column formatters and","    supplemented by other template values to the instance's `_rowTemplate` (see","    `_createRowTemplate`).  The generated string is then returned.","","    The data from Model's attributes is fetched by `toJSON` and this data","    object is appended with other properties to supply values to {placeholders}","    in the template.  For a template generated from a Model with 'foo' and 'bar'","    attributes, the data object would end up with the following properties","    before being used to populate the `_rowTemplate`:","","      * `clientID` - From Model, used the assign the `<tr>`'s 'id' attribute.","      * `foo` - The value to populate the 'foo' column cell content.  This","        value will be the value stored in the Model's `foo` attribute, or the","        result of the column's `formatter` if assigned.  If the value is '', ","        `null`, or `undefined`, and the column's `emptyCellValue` is assigned,","        that value will be used.","      * `bar` - Same for the 'bar' column cell content.","      * `foo-className` - String of CSS classes to apply to the `<td>`.","      * `bar-className` - Same.","      * `rowClass`      - String of CSS classes to apply to the `<tr>`. This","        will be the odd/even class per the specified index plus any additional","        classes assigned by column formatters (via `o.rowClass`).","","    Because this object is available to formatters, any additional properties","    can be added to fill in custom {placeholders} in the `_rowTemplate`.","","    @method _createRowHTML","    @param {Model} model The Model instance to apply to the row template","    @param {Number} index The index the row will be appearing","    @param {Object[]} columns The column configurations","    @return {HTML} The markup for the provided Model, less any `nodeFormatter`s","    @protected","    @since 3.5.0","    **/","    _createRowHTML: function (model, index, columns) {","        var data     = model.toJSON(),","            clientId = model.get('clientId'),","            values   = {","                rowId   : this._getRowId(clientId),","                clientId: clientId,","                rowClass: (index % 2) ? this.CLASS_ODD : this.CLASS_EVEN","            },","            host = this.host || this,","            i, len, col, token, value, formatterData;","","        for (i = 0, len = columns.length; i < len; ++i) {","            col   = columns[i];","            value = data[col.key];","            token = col._id || col.key;","","            values[token + '-className'] = '';","","            if (col.formatter) {","                formatterData = {","                    value    : value,","                    data     : data,","                    column   : col,","                    record   : model,","                    className: '',","                    rowClass : '',","                    rowIndex : index","                };","","                if (typeof col.formatter === 'string') {","                    if (value !== undefined) {","                        // TODO: look for known formatters by string name","                        value = fromTemplate(col.formatter, formatterData);","                    }","                } else {","                    // Formatters can either return a value","                    value = col.formatter.call(host, formatterData);","","                    // or update the value property of the data obj passed","                    if (value === undefined) {","                        value = formatterData.value;","                    }","","                    values[token + '-className'] = formatterData.className;","                    values.rowClass += ' ' + formatterData.rowClass;","                }","            }","","            if (value === undefined || value === null || value === '') {","                value = col.emptyCellValue || '';","            }","","            values[token] = col.allowHTML ? value : htmlEscape(value);","","            values.rowClass = values.rowClass.replace(/\\s+/g, ' ');","        }","","        return fromTemplate(this._rowTemplate, values);","    },","","    /**","    Creates a custom HTML template string for use in generating the markup for","    individual table rows with {placeholder}s to capture data from the Models","    in the `modelList` attribute or from column `formatter`s.","","    Assigns the `_rowTemplate` property.","","    @method _createRowTemplate","    @param {Object[]} columns Array of column configuration objects","    @protected","    @since 3.5.0","    **/","    _createRowTemplate: function (columns) {","        var html         = '',","            cellTemplate = this.CELL_TEMPLATE,","            i, len, col, key, token, headers, tokenValues;","","        for (i = 0, len = columns.length; i < len; ++i) {","            col     = columns[i];","            key     = col.key;","            token   = col._id || key;","            // Only include headers if there are more than one","            headers = (col._headers || []).length > 1 ?","                        'headers=\"' + col._headers.join(' ') + '\"' : '';","","            tokenValues = {","                content  : '{' + token + '}',","                headers  : headers,","                className: this.getClassName('col', token) + ' ' +","                           (col.className || '') + ' ' +","                           this.getClassName('cell') +","                           ' {' + token + '-className}'","            };","","            if (col.nodeFormatter) {","                // Defer all node decoration to the formatter","                tokenValues.content = '';","            }","","            html += fromTemplate(col.cellTemplate || cellTemplate, tokenValues);","        }","","        this._rowTemplate = fromTemplate(this.ROW_TEMPLATE, {","            content: html","        });","    },","","    /**","    Creates the `<tbody>` node that will store the data rows.","","    @method _createTBodyNode","    @return {Node}","    @protected","    @since 3.6.0","    **/","    _createTBodyNode: function () {","        return Y.Node.create(fromTemplate(this.TBODY_TEMPLATE, {","            className: this.getClassName('data')","        }));","    },","","    /**","    Destroys the instance.","","    @method destructor","    @protected","    @since 3.5.0","    **/","    destructor: function () {","        (new Y.EventHandle(YObject.values(this._eventHandles))).detach();","    },","","    /**","    Holds the event subscriptions needing to be detached when the instance is","    `destroy()`ed.","","    @property _eventHandles","    @type {Object}","    @default undefined (initially unset)","    @protected","    @since 3.5.0","    **/","    //_eventHandles: null,","","    /**","    Returns the row ID associated with a Model's clientId.","","    @method _getRowId","    @param {String} clientId The Model clientId","    @return {String}","    @protected","    **/","    _getRowId: function (clientId) {","        return this._idMap[clientId] || (this._idMap[clientId] = Y.guid());","    },","","    /**","    Map of Model clientIds to row ids.","","    @property _idMap","    @type {Object}","    @protected","    **/","    //_idMap,","","    /**","    Initializes the instance. Reads the following configuration properties in","    addition to the instance attributes:","","      * `columns` - (REQUIRED) The initial column information","      * `host`    - The object to serve as source of truth for column info and","                    for generating class names","","    @method initializer","    @param {Object} config Configuration data","    @protected","    @since 3.5.0","    **/","    initializer: function (config) {","        this.host = config.host;","","        this._eventHandles = {","            modelListChange: this.after('modelListChange',","                bind('_afterModelListChange', this))","        };","        this._idMap = {};","","        this.CLASS_ODD  = this.getClassName('odd');","        this.CLASS_EVEN = this.getClassName('even');","","    }","","    /**","    The HTML template used to create a full row of markup for a single Model in","    the `modelList` plus any customizations defined in the column","    configurations.","","    @property _rowTemplate","    @type {HTML}","    @default (initially unset)","    @protected","    @since 3.5.0","    **/","    //_rowTemplate: null","});","","","}, '3.7.3', {\"requires\": [\"datatable-core\", \"view\", \"classnamemanager\"]});"];
_yuitest_coverage["build/datatable-body/datatable-body.js"].lines = {"1":0,"11":0,"102":0,"201":0,"204":0,"205":0,"206":0,"207":0,"208":0,"209":0,"212":0,"213":0,"214":0,"216":0,"217":0,"218":0,"219":0,"220":0,"224":0,"225":0,"227":0,"229":0,"230":0,"235":0,"254":0,"257":0,"258":0,"260":0,"261":0,"262":0,"279":0,"284":0,"285":0,"286":0,"289":0,"290":0,"291":0,"294":0,"299":0,"313":0,"316":0,"317":0,"318":0,"321":0,"326":0,"420":0,"427":0,"429":0,"430":0,"432":0,"435":0,"436":0,"439":0,"441":0,"461":0,"478":0,"492":0,"494":0,"495":0,"496":0,"497":0,"500":0,"501":0,"516":0,"523":0,"524":0,"525":0,"529":0,"530":0,"532":0,"533":0,"542":0,"543":0,"544":0,"545":0,"547":0,"548":0,"549":0,"551":0,"552":0,"553":0,"555":0,"557":0,"563":0,"580":0,"584":0,"585":0,"589":0,"590":0,"611":0,"614":0,"615":0,"616":0,"620":0,"659":0,"669":0,"670":0,"671":0,"672":0,"674":0,"676":0,"677":0,"687":0,"688":0,"690":0,"694":0,"697":0,"698":0,"701":0,"702":0,"706":0,"707":0,"710":0,"712":0,"715":0,"731":0,"735":0,"736":0,"737":0,"738":0,"740":0,"743":0,"752":0,"754":0,"757":0,"760":0,"774":0,"787":0,"811":0,"837":0,"839":0,"843":0,"845":0,"846":0};
_yuitest_coverage["build/datatable-body/datatable-body.js"].functions = {"getCell:200":0,"getClassName:253":0,"(anonymous 2):290":0,"getRecord:278":0,"getRow:312":0,"render:419":0,"_afterColumnsChange:460":0,"_afterDataChange:474":0,"_afterModelListChange:491":0,"(anonymous 3):532":0,"_applyNodeFormatters:515":0,"bindUI:579":0,"(anonymous 4):615":0,"_createDataHTML:610":0,"_createRowHTML:658":0,"_createRowTemplate:730":0,"_createTBodyNode:773":0,"destructor:786":0,"_getRowId:810":0,"initializer:836":0,"(anonymous 1):1":0};
_yuitest_coverage["build/datatable-body/datatable-body.js"].coveredLines = 134;
_yuitest_coverage["build/datatable-body/datatable-body.js"].coveredFunctions = 21;
_yuitest_coverline("build/datatable-body/datatable-body.js", 1);
YUI.add('datatable-body', function (Y, NAME) {

/**
View class responsible for rendering the `<tbody>` section of a table. Used as
the default `bodyView` for `Y.DataTable.Base` and `Y.DataTable` classes.

@module datatable
@submodule datatable-body
@since 3.5.0
**/
_yuitest_coverfunc("build/datatable-body/datatable-body.js", "(anonymous 1)", 1);
_yuitest_coverline("build/datatable-body/datatable-body.js", 11);
var Lang         = Y.Lang,
    isArray      = Lang.isArray,
    isNumber     = Lang.isNumber,
    isString     = Lang.isString,
    fromTemplate = Lang.sub,
    htmlEscape   = Y.Escape.html,
    toArray      = Y.Array,
    bind         = Y.bind,
    YObject      = Y.Object;

/**
View class responsible for rendering the `<tbody>` section of a table. Used as
the default `bodyView` for `Y.DataTable.Base` and `Y.DataTable` classes.

Translates the provided `modelList` into a rendered `<tbody>` based on the data
in the constituent Models, altered or ammended by any special column
configurations.

The `columns` configuration, passed to the constructor, determines which
columns will be rendered.

The rendering process involves constructing an HTML template for a complete row
of data, built by concatenating a customized copy of the instance's
`CELL_TEMPLATE` into the `ROW_TEMPLATE` once for each column.  This template is
then populated with values from each Model in the `modelList`, aggregating a
complete HTML string of all row and column data.  A `<tbody>` Node is then created from the markup and any column `nodeFormatter`s are applied.

Supported properties of the column objects include:

  * `key` - Used to link a column to an attribute in a Model.
  * `name` - Used for columns that don't relate to an attribute in the Model
    (`formatter` or `nodeFormatter` only) if the implementer wants a
    predictable name to refer to in their CSS.
  * `cellTemplate` - Overrides the instance's `CELL_TEMPLATE` for cells in this
    column only.
  * `formatter` - Used to customize or override the content value from the
    Model.  These do not have access to the cell or row Nodes and should
    return string (HTML) content.
  * `nodeFormatter` - Used to provide content for a cell as well as perform any
    custom modifications on the cell or row Node that could not be performed by
    `formatter`s.  Should be used sparingly for better performance.
  * `emptyCellValue` - String (HTML) value to use if the Model data for a
    column, or the content generated by a `formatter`, is the empty string,
    `null`, or `undefined`.
  * `allowHTML` - Set to `true` if a column value, `formatter`, or
    `emptyCellValue` can contain HTML.  This defaults to `false` to protect
    against XSS.
  * `className` - Space delimited CSS classes to add to all `<td>`s in a column.

Column `formatter`s are passed an object (`o`) with the following properties:

  * `value` - The current value of the column's associated attribute, if any.
  * `data` - An object map of Model keys to their current values.
  * `record` - The Model instance.
  * `column` - The column configuration object for the current column.
  * `className` - Initially empty string to allow `formatter`s to add CSS 
    classes to the cell's `<td>`.
  * `rowIndex` - The zero-based row number.
  * `rowClass` - Initially empty string to allow `formatter`s to add CSS
    classes to the cell's containing row `<tr>`.

They may return a value or update `o.value` to assign specific HTML content.  A
returned value has higher precedence.

Column `nodeFormatter`s are passed an object (`o`) with the following
properties:

  * `value` - The current value of the column's associated attribute, if any.
  * `td` - The `<td>` Node instance.
  * `cell` - The `<div>` liner Node instance if present, otherwise, the `<td>`.
    When adding content to the cell, prefer appending into this property.
  * `data` - An object map of Model keys to their current values.
  * `record` - The Model instance.
  * `column` - The column configuration object for the current column.
  * `rowIndex` - The zero-based row number.

They are expected to inject content into the cell's Node directly, including
any "empty" cell content.  Each `nodeFormatter` will have access through the
Node API to all cells and rows in the `<tbody>`, but not to the `<table>`, as
it will not be attached yet.

If a `nodeFormatter` returns `false`, the `o.td` and `o.cell` Nodes will be
`destroy()`ed to remove them from the Node cache and free up memory.  The DOM
elements will remain as will any content added to them.  _It is highly
advisable to always return `false` from your `nodeFormatter`s_.

@class BodyView
@namespace DataTable
@extends View
@since 3.5.0
**/
_yuitest_coverline("build/datatable-body/datatable-body.js", 102);
Y.namespace('DataTable').BodyView = Y.Base.create('tableBody', Y.View, [], {
    // -- Instance properties -------------------------------------------------

    /**
    HTML template used to create table cells.

    @property CELL_TEMPLATE
    @type {HTML}
    @default '<td {headers} class="{className}">{content}</td>'
    @since 3.5.0
    **/
    CELL_TEMPLATE: '<td {headers} class="{className}">{content}</td>',

    /**
    CSS class applied to even rows.  This is assigned at instantiation.
    
    For DataTable, this will be `yui3-datatable-even`.

    @property CLASS_EVEN
    @type {String}
    @default 'yui3-table-even'
    @since 3.5.0
    **/
    //CLASS_EVEN: null

    /**
    CSS class applied to odd rows.  This is assigned at instantiation.
    
    When used by DataTable instances, this will be `yui3-datatable-odd`.

    @property CLASS_ODD
    @type {String}
    @default 'yui3-table-odd'
    @since 3.5.0
    **/
    //CLASS_ODD: null

    /**
    HTML template used to create table rows.

    @property ROW_TEMPLATE
    @type {HTML}
    @default '<tr id="{rowId}" data-yui3-record="{clientId}" class="{rowClass}">{content}</tr>'
    @since 3.5.0
    **/
    ROW_TEMPLATE : '<tr id="{rowId}" data-yui3-record="{clientId}" class="{rowClass}">{content}</tr>',

    /**
    The object that serves as the source of truth for column and row data.
    This property is assigned at instantiation from the `host` property of
    the configuration object passed to the constructor.

    @property host
    @type {Object}
    @default (initially unset)
    @since 3.5.0
    **/
    //TODO: should this be protected?
    //host: null,

    /**
    HTML templates used to create the `<tbody>` containing the table rows.

    @property TBODY_TEMPLATE
    @type {HTML}
    @default '<tbody class="{className}">{content}</tbody>'
    @since 3.6.0
    **/
    TBODY_TEMPLATE: '<tbody class="{className}"></tbody>',

    // -- Public methods ------------------------------------------------------

    /**
    Returns the `<td>` Node from the given row and column index.  Alternately,
    the `seed` can be a Node.  If so, the nearest ancestor cell is returned.
    If the `seed` is a cell, it is returned.  If there is no cell at the given
    coordinates, `null` is returned.

    Optionally, include an offset array or string to return a cell near the
    cell identified by the `seed`.  The offset can be an array containing the
    number of rows to shift followed by the number of columns to shift, or one
    of "above", "below", "next", or "previous".

    <pre><code>// Previous cell in the previous row
    var cell = table.getCell(e.target, [-1, -1]);

    // Next cell
    var cell = table.getCell(e.target, 'next');
    var cell = table.getCell(e.taregt, [0, 1];</pre></code>

    @method getCell
    @param {Number[]|Node} seed Array of row and column indexes, or a Node that
        is either the cell itself or a descendant of one.
    @param {Number[]|String} [shift] Offset by which to identify the returned
        cell Node
    @return {Node}
    @since 3.5.0
    **/
    getCell: function (seed, shift) {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "getCell", 200);
_yuitest_coverline("build/datatable-body/datatable-body.js", 201);
var tbody = this.tbodyNode,
            row, cell, index, rowIndexOffset;

        _yuitest_coverline("build/datatable-body/datatable-body.js", 204);
if (seed && tbody) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 205);
if (isArray(seed)) {
                _yuitest_coverline("build/datatable-body/datatable-body.js", 206);
row = tbody.get('children').item(seed[0]);
                _yuitest_coverline("build/datatable-body/datatable-body.js", 207);
cell = row && row.get('children').item(seed[1]);
            } else {_yuitest_coverline("build/datatable-body/datatable-body.js", 208);
if (Y.instanceOf(seed, Y.Node)) {
                _yuitest_coverline("build/datatable-body/datatable-body.js", 209);
cell = seed.ancestor('.' + this.getClassName('cell'), true);
            }}

            _yuitest_coverline("build/datatable-body/datatable-body.js", 212);
if (cell && shift) {
                _yuitest_coverline("build/datatable-body/datatable-body.js", 213);
rowIndexOffset = tbody.get('firstChild.rowIndex');
                _yuitest_coverline("build/datatable-body/datatable-body.js", 214);
if (isString(shift)) {
                    // TODO this should be a static object map
                    _yuitest_coverline("build/datatable-body/datatable-body.js", 216);
switch (shift) {
                        case 'above'   : _yuitest_coverline("build/datatable-body/datatable-body.js", 217);
shift = [-1, 0]; break;
                        case 'below'   : _yuitest_coverline("build/datatable-body/datatable-body.js", 218);
shift = [1, 0]; break;
                        case 'next'    : _yuitest_coverline("build/datatable-body/datatable-body.js", 219);
shift = [0, 1]; break;
                        case 'previous': _yuitest_coverline("build/datatable-body/datatable-body.js", 220);
shift = [0, -1]; break;
                    }
                }

                _yuitest_coverline("build/datatable-body/datatable-body.js", 224);
if (isArray(shift)) {
                    _yuitest_coverline("build/datatable-body/datatable-body.js", 225);
index = cell.get('parentNode.rowIndex') +
                                shift[0] - rowIndexOffset;
                    _yuitest_coverline("build/datatable-body/datatable-body.js", 227);
row   = tbody.get('children').item(index);

                    _yuitest_coverline("build/datatable-body/datatable-body.js", 229);
index = cell.get('cellIndex') + shift[1];
                    _yuitest_coverline("build/datatable-body/datatable-body.js", 230);
cell  = row && row.get('children').item(index);
                }
            }
        }
        
        _yuitest_coverline("build/datatable-body/datatable-body.js", 235);
return cell || null;
    },

    /**
    Returns the generated CSS classname based on the input.  If the `host`
    attribute is configured, it will attempt to relay to its `getClassName`
    or use its static `NAME` property as a string base.
    
    If `host` is absent or has neither method nor `NAME`, a CSS classname
    will be generated using this class's `NAME`.

    @method getClassName
    @param {String} token* Any number of token strings to assemble the
        classname from.
    @return {String}
    @protected
    @since 3.5.0
    **/
    getClassName: function () {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "getClassName", 253);
_yuitest_coverline("build/datatable-body/datatable-body.js", 254);
var host = this.host,
            args;

        _yuitest_coverline("build/datatable-body/datatable-body.js", 257);
if (host && host.getClassName) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 258);
return host.getClassName.apply(host, arguments);
        } else {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 260);
args = toArray(arguments);
            _yuitest_coverline("build/datatable-body/datatable-body.js", 261);
args.unshift(this.constructor.NAME);
            _yuitest_coverline("build/datatable-body/datatable-body.js", 262);
return Y.ClassNameManager.getClassName
                .apply(Y.ClassNameManager, args);
        }
    },

    /**
    Returns the Model associated to the row Node or id provided. Passing the
    Node or id for a descendant of the row also works.

    If no Model can be found, `null` is returned.

    @method getRecord
    @param {String|Node} seed Row Node or `id`, or one for a descendant of a row
    @return {Model}
    @since 3.5.0
    **/
    getRecord: function (seed) {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "getRecord", 278);
_yuitest_coverline("build/datatable-body/datatable-body.js", 279);
var modelList = this.get('modelList'),
            tbody     = this.tbodyNode,
            row       = null,
            record;

        _yuitest_coverline("build/datatable-body/datatable-body.js", 284);
if (tbody) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 285);
if (isString(seed)) {
                _yuitest_coverline("build/datatable-body/datatable-body.js", 286);
seed = tbody.one('#' + seed);
            }

            _yuitest_coverline("build/datatable-body/datatable-body.js", 289);
if (Y.instanceOf(seed, Y.Node)) {
                _yuitest_coverline("build/datatable-body/datatable-body.js", 290);
row = seed.ancestor(function (node) {
                    _yuitest_coverfunc("build/datatable-body/datatable-body.js", "(anonymous 2)", 290);
_yuitest_coverline("build/datatable-body/datatable-body.js", 291);
return node.get('parentNode').compareTo(tbody);
                }, true);

                _yuitest_coverline("build/datatable-body/datatable-body.js", 294);
record = row &&
                    modelList.getByClientId(row.getData('yui3-record'));
            }
        }

        _yuitest_coverline("build/datatable-body/datatable-body.js", 299);
return record || null;
    },

    /**
    Returns the `<tr>` Node from the given row index, Model, or Model's
    `clientId`.  If the rows haven't been rendered yet, or if the row can't be
    found by the input, `null` is returned.

    @method getRow
    @param {Number|String|Model} id Row index, Model instance, or clientId
    @return {Node}
    @since 3.5.0
    **/
    getRow: function (id) {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "getRow", 312);
_yuitest_coverline("build/datatable-body/datatable-body.js", 313);
var tbody = this.tbodyNode,
            row = null;

        _yuitest_coverline("build/datatable-body/datatable-body.js", 316);
if (tbody) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 317);
if (id) {
                _yuitest_coverline("build/datatable-body/datatable-body.js", 318);
id = this._idMap[id.get ? id.get('clientId') : id] || id;
            }

            _yuitest_coverline("build/datatable-body/datatable-body.js", 321);
row = isNumber(id) ?
                tbody.get('children').item(id) :
                tbody.one('#' + id);
        }

        _yuitest_coverline("build/datatable-body/datatable-body.js", 326);
return row;
    },

    /**
    Creates the table's `<tbody>` content by assembling markup generated by
    populating the `ROW\_TEMPLATE`, and `CELL\_TEMPLATE` templates with content
    from the `columns` and `modelList` attributes.

    The rendering process happens in three stages:

    1. A row template is assembled from the `columns` attribute (see
       `_createRowTemplate`)

    2. An HTML string is built up by concatening the application of the data in
       each Model in the `modelList` to the row template. For cells with
       `formatter`s, the function is called to generate cell content. Cells
       with `nodeFormatter`s are ignored. For all other cells, the data value
       from the Model attribute for the given column key is used.  The
       accumulated row markup is then inserted into the container.

    3. If any column is configured with a `nodeFormatter`, the `modelList` is
       iterated again to apply the `nodeFormatter`s.

    Supported properties of the column objects include:

      * `key` - Used to link a column to an attribute in a Model.
      * `name` - Used for columns that don't relate to an attribute in the Model
        (`formatter` or `nodeFormatter` only) if the implementer wants a
        predictable name to refer to in their CSS.
      * `cellTemplate` - Overrides the instance's `CELL_TEMPLATE` for cells in
        this column only.
      * `formatter` - Used to customize or override the content value from the
        Model.  These do not have access to the cell or row Nodes and should
        return string (HTML) content.
      * `nodeFormatter` - Used to provide content for a cell as well as perform
        any custom modifications on the cell or row Node that could not be
        performed by `formatter`s.  Should be used sparingly for better
        performance.
      * `emptyCellValue` - String (HTML) value to use if the Model data for a
        column, or the content generated by a `formatter`, is the empty string,
        `null`, or `undefined`.
      * `allowHTML` - Set to `true` if a column value, `formatter`, or
        `emptyCellValue` can contain HTML.  This defaults to `false` to protect
        against XSS.
      * `className` - Space delimited CSS classes to add to all `<td>`s in a
        column.

    Column `formatter`s are passed an object (`o`) with the following
    properties:

      * `value` - The current value of the column's associated attribute, if
        any.
      * `data` - An object map of Model keys to their current values.
      * `record` - The Model instance.
      * `column` - The column configuration object for the current column.
      * `className` - Initially empty string to allow `formatter`s to add CSS 
        classes to the cell's `<td>`.
      * `rowIndex` - The zero-based row number.
      * `rowClass` - Initially empty string to allow `formatter`s to add CSS
        classes to the cell's containing row `<tr>`.

    They may return a value or update `o.value` to assign specific HTML
    content.  A returned value has higher precedence.

    Column `nodeFormatter`s are passed an object (`o`) with the following
    properties:

      * `value` - The current value of the column's associated attribute, if
        any.
      * `td` - The `<td>` Node instance.
      * `cell` - The `<div>` liner Node instance if present, otherwise, the
        `<td>`.  When adding content to the cell, prefer appending into this
        property.
      * `data` - An object map of Model keys to their current values.
      * `record` - The Model instance.
      * `column` - The column configuration object for the current column.
      * `rowIndex` - The zero-based row number.

    They are expected to inject content into the cell's Node directly, including
    any "empty" cell content.  Each `nodeFormatter` will have access through the
    Node API to all cells and rows in the `<tbody>`, but not to the `<table>`,
    as it will not be attached yet.

    If a `nodeFormatter` returns `false`, the `o.td` and `o.cell` Nodes will be
    `destroy()`ed to remove them from the Node cache and free up memory.  The
    DOM elements will remain as will any content added to them.  _It is highly
    advisable to always return `false` from your `nodeFormatter`s_.

    @method render
    @return {BodyView} The instance
    @chainable
    @since 3.5.0
    **/
    render: function () {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "render", 419);
_yuitest_coverline("build/datatable-body/datatable-body.js", 420);
var table   = this.get('container'),
            data    = this.get('modelList'),
            columns = this.get('columns'),
            tbody   = this.tbodyNode ||
                      (this.tbodyNode = this._createTBodyNode());
        
        // Needed for mutation
        _yuitest_coverline("build/datatable-body/datatable-body.js", 427);
this._createRowTemplate(columns);

        _yuitest_coverline("build/datatable-body/datatable-body.js", 429);
if (data) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 430);
tbody.setHTML(this._createDataHTML(columns));

            _yuitest_coverline("build/datatable-body/datatable-body.js", 432);
this._applyNodeFormatters(tbody, columns);
        }

        _yuitest_coverline("build/datatable-body/datatable-body.js", 435);
if (tbody.get('parentNode') !== table) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 436);
table.appendChild(tbody);
        }

        _yuitest_coverline("build/datatable-body/datatable-body.js", 439);
this.bindUI();

        _yuitest_coverline("build/datatable-body/datatable-body.js", 441);
return this;
    },

    // -- Protected and private methods ---------------------------------------
    /**
    Handles changes in the source's columns attribute.  Redraws the table data.

    @method _afterColumnsChange
    @param {EventFacade} e The `columnsChange` event object
    @protected
    @since 3.5.0
    **/
    // TODO: Preserve existing DOM
    // This will involve parsing and comparing the old and new column configs
    // and reacting to four types of changes:
    // 1. formatter, nodeFormatter, emptyCellValue changes
    // 2. column deletions
    // 3. column additions
    // 4. column moves (preserve cells)
    _afterColumnsChange: function (e) {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "_afterColumnsChange", 460);
_yuitest_coverline("build/datatable-body/datatable-body.js", 461);
this.render();
    },

    /**
    Handles modelList changes, including additions, deletions, and updates.

    Modifies the existing table DOM accordingly.

    @method _afterDataChange
    @param {EventFacade} e The `change` event from the ModelList
    @protected
    @since 3.5.0
    **/
    _afterDataChange: function (e) {
        //var type = e.type.slice(e.type.lastIndexOf(':') + 1);

        // TODO: Isolate changes
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "_afterDataChange", 474);
_yuitest_coverline("build/datatable-body/datatable-body.js", 478);
this.render();
    },

    /**
    Handles replacement of the modelList.

    Rerenders the `<tbody>` contents.

    @method _afterModelListChange
    @param {EventFacade} e The `modelListChange` event
    @protected
    @since 3.6.0
    **/
    _afterModelListChange: function (e) {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "_afterModelListChange", 491);
_yuitest_coverline("build/datatable-body/datatable-body.js", 492);
var handles = this._eventHandles;

        _yuitest_coverline("build/datatable-body/datatable-body.js", 494);
if (handles.dataChange) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 495);
handles.dataChange.detach();
            _yuitest_coverline("build/datatable-body/datatable-body.js", 496);
delete handles.dataChange;
            _yuitest_coverline("build/datatable-body/datatable-body.js", 497);
this.bindUI();
        }

        _yuitest_coverline("build/datatable-body/datatable-body.js", 500);
if (this.tbodyNode) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 501);
this.render();
        }
    },

    /**
    Iterates the `modelList`, and calls any `nodeFormatter`s found in the
    `columns` param on the appropriate cell Nodes in the `tbody`.

    @method _applyNodeFormatters
    @param {Node} tbody The `<tbody>` Node whose columns to update
    @param {Object[]} columns The column configurations
    @protected
    @since 3.5.0
    **/
    _applyNodeFormatters: function (tbody, columns) {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "_applyNodeFormatters", 515);
_yuitest_coverline("build/datatable-body/datatable-body.js", 516);
var host = this.host,
            data = this.get('modelList'),
            formatters = [],
            linerQuery = '.' + this.getClassName('liner'),
            rows, i, len;

        // Only iterate the ModelList again if there are nodeFormatters
        _yuitest_coverline("build/datatable-body/datatable-body.js", 523);
for (i = 0, len = columns.length; i < len; ++i) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 524);
if (columns[i].nodeFormatter) {
                _yuitest_coverline("build/datatable-body/datatable-body.js", 525);
formatters.push(i);
            }
        }

        _yuitest_coverline("build/datatable-body/datatable-body.js", 529);
if (data && formatters.length) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 530);
rows = tbody.get('childNodes');

            _yuitest_coverline("build/datatable-body/datatable-body.js", 532);
data.each(function (record, index) {
                _yuitest_coverfunc("build/datatable-body/datatable-body.js", "(anonymous 3)", 532);
_yuitest_coverline("build/datatable-body/datatable-body.js", 533);
var formatterData = {
                        data      : record.toJSON(),
                        record    : record,
                        rowIndex  : index
                    },
                    row = rows.item(index),
                    i, len, col, key, cells, cell, keep;


                _yuitest_coverline("build/datatable-body/datatable-body.js", 542);
if (row) {
                    _yuitest_coverline("build/datatable-body/datatable-body.js", 543);
cells = row.get('childNodes');
                    _yuitest_coverline("build/datatable-body/datatable-body.js", 544);
for (i = 0, len = formatters.length; i < len; ++i) {
                        _yuitest_coverline("build/datatable-body/datatable-body.js", 545);
cell = cells.item(formatters[i]);

                        _yuitest_coverline("build/datatable-body/datatable-body.js", 547);
if (cell) {
                            _yuitest_coverline("build/datatable-body/datatable-body.js", 548);
col = formatterData.column = columns[formatters[i]];
                            _yuitest_coverline("build/datatable-body/datatable-body.js", 549);
key = col.key || col.id;

                            _yuitest_coverline("build/datatable-body/datatable-body.js", 551);
formatterData.value = record.get(key);
                            _yuitest_coverline("build/datatable-body/datatable-body.js", 552);
formatterData.td    = cell;
                            _yuitest_coverline("build/datatable-body/datatable-body.js", 553);
formatterData.cell  = cell.one(linerQuery) || cell;

                            _yuitest_coverline("build/datatable-body/datatable-body.js", 555);
keep = col.nodeFormatter.call(host,formatterData);

                            _yuitest_coverline("build/datatable-body/datatable-body.js", 557);
if (keep === false) {
                                // Remove from the Node cache to reduce
                                // memory footprint.  This also purges events,
                                // which you shouldn't be scoping to a cell
                                // anyway.  You've been warned.  Incidentally,
                                // you should always return false. Just sayin.
                                _yuitest_coverline("build/datatable-body/datatable-body.js", 563);
cell.destroy(true);
                            }
                        }
                    }
                }
            });
        }
    },

    /**
    Binds event subscriptions from the UI and the host (if assigned).

    @method bindUI
    @protected
    @since 3.5.0
    **/
    bindUI: function () {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "bindUI", 579);
_yuitest_coverline("build/datatable-body/datatable-body.js", 580);
var handles     = this._eventHandles,
            modelList   = this.get('modelList'),
            changeEvent = modelList.model.NAME + ':change';

        _yuitest_coverline("build/datatable-body/datatable-body.js", 584);
if (!handles.columnsChange) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 585);
handles.columnsChange = this.after('columnsChange',
                bind('_afterColumnsChange', this));
        }

        _yuitest_coverline("build/datatable-body/datatable-body.js", 589);
if (modelList && !handles.dataChange) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 590);
handles.dataChange = modelList.after(
                ['add', 'remove', 'reset', changeEvent],
                bind('_afterDataChange', this));
        }
    },

    /**
    Iterates the `modelList` and applies each Model to the `_rowTemplate`,
    allowing any column `formatter` or `emptyCellValue` to override cell
    content for the appropriate column.  The aggregated HTML string is
    returned.

    @method _createDataHTML
    @param {Object[]} columns The column configurations to customize the
                generated cell content or class names
    @return {HTML} The markup for all Models in the `modelList`, each applied
                to the `_rowTemplate`
    @protected
    @since 3.5.0
    **/
    _createDataHTML: function (columns) {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "_createDataHTML", 610);
_yuitest_coverline("build/datatable-body/datatable-body.js", 611);
var data = this.get('modelList'),
            html = '';

        _yuitest_coverline("build/datatable-body/datatable-body.js", 614);
if (data) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 615);
data.each(function (model, index) {
                _yuitest_coverfunc("build/datatable-body/datatable-body.js", "(anonymous 4)", 615);
_yuitest_coverline("build/datatable-body/datatable-body.js", 616);
html += this._createRowHTML(model, index, columns);
            }, this);
        }

        _yuitest_coverline("build/datatable-body/datatable-body.js", 620);
return html;
    },

    /**
    Applies the data of a given Model, modified by any column formatters and
    supplemented by other template values to the instance's `_rowTemplate` (see
    `_createRowTemplate`).  The generated string is then returned.

    The data from Model's attributes is fetched by `toJSON` and this data
    object is appended with other properties to supply values to {placeholders}
    in the template.  For a template generated from a Model with 'foo' and 'bar'
    attributes, the data object would end up with the following properties
    before being used to populate the `_rowTemplate`:

      * `clientID` - From Model, used the assign the `<tr>`'s 'id' attribute.
      * `foo` - The value to populate the 'foo' column cell content.  This
        value will be the value stored in the Model's `foo` attribute, or the
        result of the column's `formatter` if assigned.  If the value is '', 
        `null`, or `undefined`, and the column's `emptyCellValue` is assigned,
        that value will be used.
      * `bar` - Same for the 'bar' column cell content.
      * `foo-className` - String of CSS classes to apply to the `<td>`.
      * `bar-className` - Same.
      * `rowClass`      - String of CSS classes to apply to the `<tr>`. This
        will be the odd/even class per the specified index plus any additional
        classes assigned by column formatters (via `o.rowClass`).

    Because this object is available to formatters, any additional properties
    can be added to fill in custom {placeholders} in the `_rowTemplate`.

    @method _createRowHTML
    @param {Model} model The Model instance to apply to the row template
    @param {Number} index The index the row will be appearing
    @param {Object[]} columns The column configurations
    @return {HTML} The markup for the provided Model, less any `nodeFormatter`s
    @protected
    @since 3.5.0
    **/
    _createRowHTML: function (model, index, columns) {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "_createRowHTML", 658);
_yuitest_coverline("build/datatable-body/datatable-body.js", 659);
var data     = model.toJSON(),
            clientId = model.get('clientId'),
            values   = {
                rowId   : this._getRowId(clientId),
                clientId: clientId,
                rowClass: (index % 2) ? this.CLASS_ODD : this.CLASS_EVEN
            },
            host = this.host || this,
            i, len, col, token, value, formatterData;

        _yuitest_coverline("build/datatable-body/datatable-body.js", 669);
for (i = 0, len = columns.length; i < len; ++i) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 670);
col   = columns[i];
            _yuitest_coverline("build/datatable-body/datatable-body.js", 671);
value = data[col.key];
            _yuitest_coverline("build/datatable-body/datatable-body.js", 672);
token = col._id || col.key;

            _yuitest_coverline("build/datatable-body/datatable-body.js", 674);
values[token + '-className'] = '';

            _yuitest_coverline("build/datatable-body/datatable-body.js", 676);
if (col.formatter) {
                _yuitest_coverline("build/datatable-body/datatable-body.js", 677);
formatterData = {
                    value    : value,
                    data     : data,
                    column   : col,
                    record   : model,
                    className: '',
                    rowClass : '',
                    rowIndex : index
                };

                _yuitest_coverline("build/datatable-body/datatable-body.js", 687);
if (typeof col.formatter === 'string') {
                    _yuitest_coverline("build/datatable-body/datatable-body.js", 688);
if (value !== undefined) {
                        // TODO: look for known formatters by string name
                        _yuitest_coverline("build/datatable-body/datatable-body.js", 690);
value = fromTemplate(col.formatter, formatterData);
                    }
                } else {
                    // Formatters can either return a value
                    _yuitest_coverline("build/datatable-body/datatable-body.js", 694);
value = col.formatter.call(host, formatterData);

                    // or update the value property of the data obj passed
                    _yuitest_coverline("build/datatable-body/datatable-body.js", 697);
if (value === undefined) {
                        _yuitest_coverline("build/datatable-body/datatable-body.js", 698);
value = formatterData.value;
                    }

                    _yuitest_coverline("build/datatable-body/datatable-body.js", 701);
values[token + '-className'] = formatterData.className;
                    _yuitest_coverline("build/datatable-body/datatable-body.js", 702);
values.rowClass += ' ' + formatterData.rowClass;
                }
            }

            _yuitest_coverline("build/datatable-body/datatable-body.js", 706);
if (value === undefined || value === null || value === '') {
                _yuitest_coverline("build/datatable-body/datatable-body.js", 707);
value = col.emptyCellValue || '';
            }

            _yuitest_coverline("build/datatable-body/datatable-body.js", 710);
values[token] = col.allowHTML ? value : htmlEscape(value);

            _yuitest_coverline("build/datatable-body/datatable-body.js", 712);
values.rowClass = values.rowClass.replace(/\s+/g, ' ');
        }

        _yuitest_coverline("build/datatable-body/datatable-body.js", 715);
return fromTemplate(this._rowTemplate, values);
    },

    /**
    Creates a custom HTML template string for use in generating the markup for
    individual table rows with {placeholder}s to capture data from the Models
    in the `modelList` attribute or from column `formatter`s.

    Assigns the `_rowTemplate` property.

    @method _createRowTemplate
    @param {Object[]} columns Array of column configuration objects
    @protected
    @since 3.5.0
    **/
    _createRowTemplate: function (columns) {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "_createRowTemplate", 730);
_yuitest_coverline("build/datatable-body/datatable-body.js", 731);
var html         = '',
            cellTemplate = this.CELL_TEMPLATE,
            i, len, col, key, token, headers, tokenValues;

        _yuitest_coverline("build/datatable-body/datatable-body.js", 735);
for (i = 0, len = columns.length; i < len; ++i) {
            _yuitest_coverline("build/datatable-body/datatable-body.js", 736);
col     = columns[i];
            _yuitest_coverline("build/datatable-body/datatable-body.js", 737);
key     = col.key;
            _yuitest_coverline("build/datatable-body/datatable-body.js", 738);
token   = col._id || key;
            // Only include headers if there are more than one
            _yuitest_coverline("build/datatable-body/datatable-body.js", 740);
headers = (col._headers || []).length > 1 ?
                        'headers="' + col._headers.join(' ') + '"' : '';

            _yuitest_coverline("build/datatable-body/datatable-body.js", 743);
tokenValues = {
                content  : '{' + token + '}',
                headers  : headers,
                className: this.getClassName('col', token) + ' ' +
                           (col.className || '') + ' ' +
                           this.getClassName('cell') +
                           ' {' + token + '-className}'
            };

            _yuitest_coverline("build/datatable-body/datatable-body.js", 752);
if (col.nodeFormatter) {
                // Defer all node decoration to the formatter
                _yuitest_coverline("build/datatable-body/datatable-body.js", 754);
tokenValues.content = '';
            }

            _yuitest_coverline("build/datatable-body/datatable-body.js", 757);
html += fromTemplate(col.cellTemplate || cellTemplate, tokenValues);
        }

        _yuitest_coverline("build/datatable-body/datatable-body.js", 760);
this._rowTemplate = fromTemplate(this.ROW_TEMPLATE, {
            content: html
        });
    },

    /**
    Creates the `<tbody>` node that will store the data rows.

    @method _createTBodyNode
    @return {Node}
    @protected
    @since 3.6.0
    **/
    _createTBodyNode: function () {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "_createTBodyNode", 773);
_yuitest_coverline("build/datatable-body/datatable-body.js", 774);
return Y.Node.create(fromTemplate(this.TBODY_TEMPLATE, {
            className: this.getClassName('data')
        }));
    },

    /**
    Destroys the instance.

    @method destructor
    @protected
    @since 3.5.0
    **/
    destructor: function () {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "destructor", 786);
_yuitest_coverline("build/datatable-body/datatable-body.js", 787);
(new Y.EventHandle(YObject.values(this._eventHandles))).detach();
    },

    /**
    Holds the event subscriptions needing to be detached when the instance is
    `destroy()`ed.

    @property _eventHandles
    @type {Object}
    @default undefined (initially unset)
    @protected
    @since 3.5.0
    **/
    //_eventHandles: null,

    /**
    Returns the row ID associated with a Model's clientId.

    @method _getRowId
    @param {String} clientId The Model clientId
    @return {String}
    @protected
    **/
    _getRowId: function (clientId) {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "_getRowId", 810);
_yuitest_coverline("build/datatable-body/datatable-body.js", 811);
return this._idMap[clientId] || (this._idMap[clientId] = Y.guid());
    },

    /**
    Map of Model clientIds to row ids.

    @property _idMap
    @type {Object}
    @protected
    **/
    //_idMap,

    /**
    Initializes the instance. Reads the following configuration properties in
    addition to the instance attributes:

      * `columns` - (REQUIRED) The initial column information
      * `host`    - The object to serve as source of truth for column info and
                    for generating class names

    @method initializer
    @param {Object} config Configuration data
    @protected
    @since 3.5.0
    **/
    initializer: function (config) {
        _yuitest_coverfunc("build/datatable-body/datatable-body.js", "initializer", 836);
_yuitest_coverline("build/datatable-body/datatable-body.js", 837);
this.host = config.host;

        _yuitest_coverline("build/datatable-body/datatable-body.js", 839);
this._eventHandles = {
            modelListChange: this.after('modelListChange',
                bind('_afterModelListChange', this))
        };
        _yuitest_coverline("build/datatable-body/datatable-body.js", 843);
this._idMap = {};

        _yuitest_coverline("build/datatable-body/datatable-body.js", 845);
this.CLASS_ODD  = this.getClassName('odd');
        _yuitest_coverline("build/datatable-body/datatable-body.js", 846);
this.CLASS_EVEN = this.getClassName('even');

    }

    /**
    The HTML template used to create a full row of markup for a single Model in
    the `modelList` plus any customizations defined in the column
    configurations.

    @property _rowTemplate
    @type {HTML}
    @default (initially unset)
    @protected
    @since 3.5.0
    **/
    //_rowTemplate: null
});


}, '3.7.3', {"requires": ["datatable-core", "view", "classnamemanager"]});
