/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder;

import com.hisagisoft.eclipse.gadgetholder.ParseException;
import com.hisagisoft.eclipse.gadgetholder.ParserUtils;
import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import com.hisagisoft.eclipse.gadgetholder.model.GadgetList;
import com.hisagisoft.eclipse.gadgetholder.views.GadgetView;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class GadgetHolderManager {
    private static Logger logger = Logger.getLogger(GadgetHolderManager.class.getName());
    private static GadgetHolderManager instance = new GadgetHolderManager();
    private static GadgetList gadgets = new GadgetList();
    private static String PROPERTIES_FILE = "gadgetholder.properties";
    private String stateLocation;
    private String propPath;
    private GadgetView gadgetView;

    private GadgetHolderManager() {
    }

    public static GadgetHolderManager getInstance() {
        return instance;
    }

    public void setStateLocation(String stateLocation) {
        assert (stateLocation != null);
        this.stateLocation = stateLocation;
    }

    public synchronized void loadGadget() {
        assert (this.stateLocation != null);
        this.propPath = String.valueOf(this.stateLocation) + File.separator + PROPERTIES_FILE;
        logger.fine("Loading properties = " + this.propPath);
        File propFile = new File(this.propPath);
        if (!propFile.exists()) {
            logger.fine("properties not found.");
            return;
        }
        Properties prop = new Properties();
        FileInputStream fs = null;
        try {
            try {
                fs = new FileInputStream(propFile);
                prop.load(fs);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Error(e);
            }
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (prop.isEmpty()) {
            return;
        }
        int gadgetSize = Integer.parseInt(prop.getProperty("gadget.size"));
        Gadget gadget = null;
        int i = 0;
        while (i < gadgetSize) {
            gadget = new Gadget();
            int id = Integer.valueOf(prop.getProperty("gadget." + i + ".id"));
            gadget.setId(id);
            String source = prop.getProperty("gadget." + i + ".source");
            gadget.setSource(source);
            File file = this.createHtmlFile(gadget);
            gadget.setFile(file);
            gadgets.add(gadget);
            ++i;
        }
    }

    public File createHtmlFile(Gadget gadget) {
        int id = gadget.getId();
        String source = gadget.getSource();
        assert (id >= 0 && source != null);
        assert (this.stateLocation != null);
        File file = new File(String.valueOf(this.stateLocation) + File.separator + "gadget." + id + ".html");
        logger.fine("HTML file = " + file.getAbsolutePath());
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                String html = this.scriptTagToHtml(source);
                out.print(html);
            }
            catch (IOException e) {
                e.printStackTrace();
                file.deleteOnExit();
                throw new Error(e);
            }
        }
        finally {
            if (out != null) {
                out.close();
                out = null;
            }
        }
        return file;
    }

    public void removeHtmlFile() {
        assert (this.stateLocation != null);
        File dir = new File(this.stateLocation);
        String[] files = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".html");
            }
        });
        if (files.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder("remove file = \n");
        File removeFile = null;
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            removeFile = new File(String.valueOf(this.stateLocation) + File.separator + fileName);
            sb.append(removeFile.getAbsolutePath());
            sb.append("\n");
            removeFile.deleteOnExit();
            ++n2;
        }
        logger.fine(sb.toString());
    }

    private String scriptTagToHtml(String source) {
        assert (source != null);
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head>\n");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n");
        sb.append("</head><body>\n");
        sb.append(source);
        sb.append("\n</body>\n</html>\n");
        return sb.toString();
    }

    public GadgetList getGadgets() {
        return gadgets;
    }

    public synchronized void saveProperties() {
        Properties prop = new Properties();
        int size = gadgets.size();
        prop.setProperty("gadget.size", String.valueOf(size));
        int i = 0;
        while (i < size) {
            Gadget gadget = gadgets.get(i);
            prop.setProperty("gadget." + i + ".id", String.valueOf(gadget.getId()));
            prop.setProperty("gadget." + i + ".source", gadget.getSource());
            ++i;
        }
        assert (this.propPath != null);
        FileOutputStream fs = null;
        try {
            try {
                fs = new FileOutputStream(this.propPath);
                prop.store(fs, null);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new Error(e);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new Error(e);
            }
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized GadgetList importGadget(File file) throws ParseException {
        logger.fine("import file = " + file.getAbsolutePath());
        List<String> scriptTags = null;
        try {
            scriptTags = ParserUtils.getScriptTags(file);
        }
        catch (Exception e) {
            logger.warning(e.getClass() + " : " + e.getMessage());
            throw new ParseException(e);
        }
        GadgetList newGadgets = new GadgetList();
        for (String scriptTag : scriptTags) {
            Gadget newGadget = gadgets.createGadget();
            newGadget.setSource(scriptTag);
            File htmlFile = this.createHtmlFile(newGadget);
            newGadget.setFile(htmlFile);
            newGadgets.add(newGadget);
        }
        return newGadgets;
    }

    public synchronized void exportGadget(File file) {
        assert (file != null && file.getAbsolutePath() != null);
        logger.fine("export file = " + file.getAbsolutePath());
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                StringBuilder sb = new StringBuilder();
                for (Gadget g : gadgets) {
                    sb.append(g.getSource());
                    sb.append("\n\n");
                }
                String html = this.scriptTagToHtml(sb.toString());
                out.print(html);
            }
            catch (IOException e) {
                e.printStackTrace();
                file.deleteOnExit();
                throw new Error(e);
            }
        }
        finally {
            if (out != null) {
                out.close();
                out = null;
            }
        }
    }

    public GadgetView getGatgetView() {
        return this.gadgetView;
    }

    public void setGadgetView(GadgetView gadgetView) {
        this.gadgetView = gadgetView;
    }
}

