#!/bin/bash
# adbの初期化、data領域,system領域のマウント
adb kill-server
adb start-server
adb shell mount_data
adb shell mount_system

# 旧バージョンの削除。設定環境を残しつつ上書きインストールする場合はコメントアウト
adb shell busybox rm -rf /data/data_ginger
adb shell busybox rm -rf /data/system_ginger

# /system から、必要なファイルをginger領域にコピーする。
adb shell busybox mkdir /data/system_ginger
adb shell busybox cp -r /system2/lib /data/system_ginger/lib
adb shell busybox cp -r /system2/bin /data/system_ginger/bin
adb shell busybox cp -r /system2/etc /data/system_ginger/etc
adb shell busybox cp -r /system2/usr /data/system_ginger/usr

# /data から、必要なファイルをginger領域にコピーする。
adb shell busybox mkdir /data/data_ginger/misc
adb shell busybox cp -r /data/misc /data/data_ginger/misc

# gingerで生成した /system ファイルをコピーする。
adb push system/ /data/system_ginger

# 添付のアプリケーションファイルをコピーする。
adb push apps/system /data/system_ginger
adb push apps/data /data/data_ginger/app

# busybox をコピーする。
adb push busybox /data/system_ginger/bin/busybox
adb shell busybox chmod 555 /data/system_ginger/bin/busybox

# カーネルを添付の物から変える場合には、hoge.kernel を変更してGBboot.imgを作成する。
#mkbootimg --kernel hoge.kernerl --ramdisk ramdisk.bin --cmdline "console=ttyMSM2,115200n8 androidboot.hardware=qcom" --base 0x20000000 -o boot.img
#ubinize -o GBketnel.img -p 128KiB -m 2048 -O 256 ubi.cfg

# カーネルを焼く。
adb push GBkernel.img /data/data_ginger/GBkernel.img
adb shell 'flash_image recovery /data/data_ginger/GBkernel.img'
adb shell busybox rm /data/data_ginger/GBkernel.img

# recovery領域からリブート。
adb reboot recovery
