#!/bin/sh --
#	gh_portable.sh
#	Sat,23 Sep,2017
#	Sat,27 May,2023
#	Copyright(C)2017 G-HAL

check_exec()
{
  _check_file="$1"
  if [ -x ${_check_file} -a ! -d ${_check_file} ]; then
    return 0
  fi
  return 1
}

search_exec()
{
  _env_name="$1"
  _search_file="$2"
  _default_file="$3"
  if [ "x${_default_file}" = "x" ]; then
    if check_exec /bin/${_search_file}; then
      _ret=/bin/${_search_file}
      return 0
    elif check_exec /usr/bin/${_search_file}; then
      _ret=/usr/bin/${_search_file}
      return 0
    elif check_exec /usr/local/bin/${_search_file}; then
      _ret=/usr/local/bin/${_search_file}
      return 0
    else
      echo "${_search_file} not found."
      echo "Please set environment ${_env_name} where ${_search_file} is."
      return 1
    fi
  elif check_exec ${_default_file}; then
    _ret=${_default_file}
    return 0
  else
    echo "${_default_file} not found."
    echo "Please set environment ${_env_name} where ${_search_file} is."
    return 1
  fi
}

#

search_exec UNAME uname ${UNAME} || exit 1
UNAME=${_ret}
search_exec DIRNAME dirname ${DIRNAME} || exit 1
DIRNAME=${_ret}

#

ARG_DIR=`${DIRNAME} $0`
case $0 in
*gh1ch*|*gearhead1ch*|*gearheart*)
  GAME_BASENAME=gearheart.
  ;;
*gh1*|*gearhead1*|*gharena*)
  GAME_BASENAME=gharena.
  ;;
*gh2*|*gearhead2*)
  GAME_BASENAME=gearhead2.
  ;;
*qrlmaker*)
  GAME_BASENAME=qrlmaker.
  ;;
*)
  GAME_BASENAME=gharena.
  ;;
esac
case $0 in
*ascii_sdl*)
  UI_MODE=ascii_sdl.
  ;;
*ascii_mswingdi*)
  UI_MODE=ascii_mswingdi.
  ;;
*ascii*)
  UI_MODE=ascii.
  ;;
*sdl*)
  UI_MODE=sdl.
  ;;
*qrlmaker*)
  UI_MODE=
  ;;
*)
  UI_MODE=ascii.
  ;;
esac
OS_IDENT=`${UNAME} -s`_
PLATFORM_IDENT=`${UNAME} -p`
if [ "x" = "x${PLATFORM_IDENT}" -o "xunknown" = "x${PLATFORM_IDENT}" ]; then
  PLATFORM_IDENT=`${UNAME} -m`
fi

#

${ARG_DIR}/${GAME_BASENAME}${UI_MODE}${OS_IDENT}${PLATFORM_IDENT} ${ARG_DIR} $@

# [ End of File ]
