/*
 * Decompiled with CFR 0.152.
 */
package net.twoch.GikoMail;

import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.mail.internet.MimeUtility;
import net.twoch.GikoMail.MailFormat;

class MailTokenizer {
    String whole;
    String CR;
    MailFormat mf;

    public MailTokenizer(String string) {
        this.whole = string;
        this.CR = "\r\n";
        this.mf = new MailFormat();
        this.mf.to = this.getTo();
        this.mf.from = this.getFrom();
        this.mf.subject = this.getSubject();
        this.mf.date = this.getDate();
        this.mf.cc = this.getCc();
        this.mf.data = this.getBody();
        this.mf.header = this.getHeader();
    }

    public MailTokenizer(StringBuffer stringBuffer) {
        this.whole = new String(stringBuffer);
        this.CR = "\r\n";
        this.mf = new MailFormat();
        this.mf.to = this.getTo();
        this.mf.from = this.getFrom();
        this.mf.subject = this.getSubject();
        this.mf.date = this.getDate();
        this.mf.cc = this.getCc();
        this.mf.data = this.getBody();
        this.mf.header = this.getHeader();
    }

    public MailFormat getMail() {
        return this.mf;
    }

    public String getFrom() {
        String string = this.getField("From: ");
        if (string == null) {
            string = "";
        }
        String string2 = "";
        try {
            string2 = MimeUtility.decodeText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public String getTo() {
        String string = this.getField("To: ");
        if (string == null) {
            string = "";
        }
        String string2 = "";
        try {
            string2 = MimeUtility.decodeText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public String getCc() {
        String string = this.getField("Cc: ");
        if (string == null) {
            string = "";
        }
        String string2 = "";
        try {
            string2 = MimeUtility.decodeText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public String getSubject() {
        String string = this.getField("Subject: ");
        if (string == null) {
            string = "";
        }
        String string2 = "";
        try {
            string2 = MimeUtility.decodeText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public String getDate() {
        String string = this.getField("Date: ");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getField(String string) {
        int n = this.whole.indexOf(string);
        if (n < 0) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.whole.substring(n + string.length()), this.CR);
        return stringTokenizer.nextToken();
    }

    public String getBody() {
        String string = this.CR + this.CR;
        int n = this.whole.indexOf(string);
        if (n < 0) {
            return "";
        }
        String string2 = this.whole.substring(n + 2);
        try {
            String string3 = new String(string2.getBytes("SJIS"));
            return string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public String getHeader() {
        String string = this.CR + this.CR;
        int n = this.whole.indexOf(string);
        if (n < 0) {
            return "";
        }
        String string2 = "";
        try {
            string2 = MimeUtility.decodeText(this.whole.substring(0, n));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public String toString() {
        return this.whole;
    }
}

