use constant TRUE  => 1;
use constant FALSE => 0;


sub gnFirstRun {
   # 初回起動時にウィザードを起動して、gikoNavi.iniとログディレクトリを
   # 指定する
   #
   # 引数: なし
   # 返り値: なし
   #my $gladefn = $_[0];
   $gnFRxml = Gtk2::GladeXML->new($gladefn, 'gnInitialConfig');
   $gnFRxml->signal_autoconnect_from_package('main');
   my $gnFirstRunGUI = $gnFRxml->get_widget('gnInitialConfig');
   if($gnDebugFlag) { print Dumper($gnFirstRunGUI); }
   
   my $gnFRIniChoose = $gnFRxml->get_widget('gnFRIniChoose');
   my $gnFRIniFilter = Gtk2::FileFilter->new;
   $gnFRIniFilter->add_pattern('gikoNavi.ini');
   $gnFRIniChoose->set_filter($gnFRIniFilter);
   
   $gnFirstRunGUI->queue_resize;
   $gnFirstRunGUI->show_all;
   
   my $gnFRpage = 0;
   
}

sub gnFR_next {
   my $gnFRnextButton = $_[0];
   my $gnFRnote = $gnFRxml->get_widget('gnFRnote');
   my $gnFRnoteP = $gnFRnote->get_current_page;
   
   if ($gnFRnoteP == ($gnFRnote->get_n_pages-1)) {
      # 最終ページなので終了処理
      my $gnFRIni = $gnFRxml->get_widget('gnFRIniChoose');
      $gnInitCfg{'Main'}{'gikoNavi.ini'} = $gnFRIni->get_filename;
      if($gnDebugFlag) { print "$gnInitCfg{'Main'}{'gikoNavi.ini'}\n"; }
      my $gnFRUrl = $gnFRxml->get_widget('gnFRUrlChoose');
      $gnInitCfg{'Main'}{'url.ini'} = $gnFRUrl->get_filename;
      if($gnDebugFlag) { print "$gnInitCfg{'Main'}{'url.ini'}\n"; }
      my $gnFRSent = $gnFRxml->get_widget('gnFRSentChoose');
      $gnInitCfg{'Main'}{'sent.ini'} = $gnFRSent->get_filename;
      if($gnDebugFlag) { print "$gnInitCfg{'Main'}{'sent.ini'}\n"; }
      my $gnFRLog = $gnFRxml->get_widget('gnFRLogChoose');
      $gnInitCfg{'Main'}{'LogFolder'} = $gnFRLog->get_filename;
      if($gnDebugFlag) { print "$gnInitCfg{'Main'}{'LogFolder'}\n"; }
      
      $gnEnvFile = $gnInitCfg{'Main'}{'gikoNavi.ini'};
      $gnURLIniFile = $gnInitCfg{'Main'}{'url.ini'};
      $gnSentIniFile = $gnInitCfg{'Main'}{'sent.ini'};
      $logdir = $gnInitCfg{'Main'}{'LogFolder'} . "\/2ch\/";
      
      
      if (!(-d $logdir)) {
             my $gnFirstRunGUI = $gnFRxml->get_widget('gnInitialConfig');
             my $gnMsgDialog = Gtk2::MessageDialog->new($gnFirstRunGUI,
                                                           'GTK_DIALOG_MODAL',
                                                           'GTK_MESSAGE_INFO',
                                                           'GTK_BUTTONS_YES_NO',
                                                           "2chディレクトリがありません。\n作成しますか？",
                                                           ,
                                                           'GTK_BUTTONS_YES' => 'gtk-yes',
                                                           'GTK_BUTTONS_NO' => 'gtk-no');
             if($gnMsgDialog->run eq 'yes') {
                $gnMsgDialog->destroy;
                undef($gnMsgDialog);
                mkdir($logdir);
             }else{
                $gnMsgDialog->destroy;
                undef($gnMsgDialog);
                exit(1);
             }
         
      }

      # <設定ディレクトリ>/.gnviewconfigへ書き込み
      if (!(-d $gnCfgPath)) {
             my $gnFirstRunGUI = $gnFRxml->get_widget('gnInitialConfig');
             my $gnMsgDialog = Gtk2::MessageDialog->new($gnFirstRunGUI,
                                                           'GTK_DIALOG_MODAL',
                                                           'GTK_MESSAGE_INFO',
                                                           'GTK_BUTTONS_YES_NO',
                                                           Encode::decode('utf8',"設定ファイルを格納するディレクトリがありません。\n作成しますか？"),
                                                           ,
                                                           'GTK_BUTTONS_YES' => 'gtk-yes',
                                                           'GTK_BUTTONS_NO' => 'gtk-no');
             if($gnMsgDialog->run eq 'yes') {
                $gnMsgDialog->destroy;
                undef($gnMsgDialog);
                mkdir($gnCfgPath);
             }else{
                $gnMsgDialog->destroy;
                undef($gnMsgDialog);
                exit(1);
             }
         
      }
      # 画像キャッシュテーブルの初期化
      $gnInitCfg{'Main'}{'cachetbl.ini'} = $gnCfgPath . "cachetbl.ini";
      if (!(-e $gnInitCfg{'Main'}{'cachetbl.ini'})) {
         open(gnCTBL, ">$gnInitCfg{'Main'}{'cachetbl.ini'}");
         close(gnCTBL);
      }
      
      my $gnInitCfgFN = $gnCfgPath . ".gnviewconfig";
      $gnInitCfg{'Main'}{'gnCfgPath'} = $gnCfgPath;
      if($gnDebugFlag) { print Dumper(%gnInitCfg); }
      &gnSaveEnv($gnInitCfgFN, \%gnInitCfg);
      
      my $gnFirstRunGUI = $gnFRxml->get_widget('gnInitialConfig');
      $gnFirstRunGUI->destroy;
      
      &gnInit;
      
   }else{
      
      if ($gnFRnoteP == 0) {
         # 次のページが2ページ目(0スタートの1)の場合は
         # ボタンのアイコンとラベルを変える
         my $gnFRprevButton = $gnFRxml->get_widget('gnFRprev');
         $gnFRprevButton->set_image(Gtk2::Image->new_from_stock('gtk-go-back','button'));
         my $gnFRprevButtonStr = Encode::decode('utf8', "戻る");
         $gnFRprevButton->set_label($gnFRprevButtonStr);
      }
      
      if (($gnFRnoteP+1) == $gnFRnote->get_n_pages-1) {
         # 次のページが最終ページの場合は
         # ボタンのアイコンとラベルを変える
         $gnFRnextButton->set_image(Gtk2::Image->new_from_stock('gtk-ok','button'));
         $gnFRnextButton->set_label('OK');
      }
      
      # 次のページに進む
      $gnFRnote->next_page;
   }
   
   
   
}

sub gnFR_prev {
   my $gnFRprevButton = $_[0];
   my $gnFRnote = $gnFRxml->get_widget('gnFRnote');
   my $gnFRnoteP = $gnFRnote->get_current_page;
   if (($gnFRnoteP-1) < 0) {
      # 最初のページなのでキャンセル処理
      my $gnFirstRunGUI = $gnFRxml->get_widget('gnInitialConfig');
      my $gnMsgDialog = Gtk2::MessageDialog->new($gnFirstRunGUI,
                                                    'GTK_DIALOG_MODAL',
                                                    'GTK_MESSAGE_INFO',
                                                    'GTK_BUTTONS_YES_NO',
                                                    "初期設定を中断しますか？\n（設定は保存されません）",
                                                     ,
                                                    'GTK_BUTTONS_YES' => 'gtk-yes',
                                                    'GTK_BUTTONS_NO' => 'gtk-no');
      if($gnMsgDialog->run eq 'yes') {
          $gnMsgDialog->destroy;
          undef($gnMsgDialog);
          exit(0);
      }else{
          $gnMsgDialog->destroy;
          undef($gnMsgDialog);
      }
   }else{
      
      if ($gnFRnoteP == $gnFRnote->get_n_pages-1) {
         # 前のページが最終ページの1ページ前の場合は
         # ボタンのアイコンとラベルを変える
         my $gnFRnextButton = $gnFRxml->get_widget('gnFRnext');
         $gnFRnextButton->set_image(Gtk2::Image->new_from_stock('gtk-go-forward','button'));
         $gnFRnextButton->set_label('進む');
      }
      
      if ($gnFRnoteP == 1) {
         # 戻った後のページが1ページ目(0スタートの0)の場合は
         # ボタンのアイコンとラベルを変える
         $gnFRprevButton->set_image(Gtk2::Image->new_from_stock('gtk-cancel','button'));
         $gnFRprevButton->set_label('キャンセル');
      }
      
      # 前のページに戻る
      $gnFRnote->prev_page;
   }
}

1;

