//// データ関係のクラス
// 結合されたデータのバッファー
class Data {
  OneData [] body = {};
  int     num;           // 読み込まれたファイル数
  // コンストラクター
  Data() {
    num  = 0;
  }
  // リストを全て削除する
  void allclear() {
    body = (OneData [])expand(body, 0);
    num  = 0;
    ex_file.export_folder = "";
  }
  // １ファイルのデータをメモリにストア（リストを追加）する
  boolean store(OneData src) {
    OneData d = new OneData();
    body = (OneData [])append(body, d);
    if (body == null) {
      shortMessage.set_message("Error: Can't allocate memory");
      return false;
    }
    num++;
    return store(body.length - 1, src);
  }
  boolean store(int index, OneData src) {
    if (index > num) return false;
    body[index] = src; 
    return true;
  }
} //<>//

// data内の全データを比較してソーティング（昇順）を行うクラス //<>//
class Sorting {
  CompareString cs;
  int           line;
  boolean       orderByFilename;
  boolean       orderByTime;
  // コンストラクター
  Sorting() {
    cs              = new CompareString();
    line            = 0;
    orderByFilename = false;
    orderByTime     = false;
  }
  // ファイル名でソーティング（バブルソート）
  void sortByFilename() {
    OneData temp;
    for (int i = 0; i < data.num - 1; i++) {
      for (int j = data.num - 1; j > i; j--) {
        if (cs.compare(data.body[j-1].filename, data.body[j].filename) == 1) {
          temp = data.body[j-1];
          data.body[j-1] = data.body[j];
          data.body[j] = temp;
        }
      }
    }
    refreshCheck();
  }
  // 計測日時でソーティング（バブルソート）
  void sortByTime() {
    OneData temp;
    for (int i = 0; i < data.num - 1; i++) {
      for (int j = data.num - 1; j > i; j--) {
        if (cs.compare(data.body[j-1].dateString, data.body[j].dateString) == 1) {
          temp = data.body[j-1];
          data.body[j-1] = data.body[j];
          data.body[j] = temp;
        }
      }
    }
    refreshCheck();
  }
  
  // チェック結果を更新
  void refreshCheck() {
    checkByFilename();
    checkByTime();
  }
  // ファイル名で比較（データが無い場合はfalse）
  boolean checkByFilename() {
    orderByFilename = _checkByFilename();
    return orderByFilename;
  }
  boolean _checkByFilename() {
    String str1, str2;
    line = -1;
    if (data.num <= 0) return false;
    str1 = data.body[0].filename;
    for (int i = 1; i < data.num; i++) {
      line = i;
      str2 = data.body[i].filename;
      if (cs.compare(str1, str2) != -1) return false;
      str1 = str2;
    }
    return true;
  }
  // 計測日時で比較（データが無い場合はfalse）
  boolean checkByTime() {
    orderByTime = _checkByTime();
    return orderByTime;
  }
  boolean _checkByTime() {
    String str1, str2;
    line = -1;
    if (data.num <= 0) return false; //<>//
    str1 = data.body[0].dateString;
    for (int i = 1; i < data.num; i++) {
      line = i;
      str2 = data.body[i].dateString;
      if (cs.compare(str1, str2) != -1) return false;
      str1 = str2;
    }
    return true;
  }
}

// 連続して座標データファイルを読み込むクラス
class ImportFile extends ImportMeasuredFile {
  boolean noConversion;  // 計測データを読み込む際にscaleによる変換を行わない（Ver.3.0以降）
  // コンストラクター
  ImportFile() {
    noConversion = true;
  }
  
  // 与えられたファイルリストに従ってファイルを読み込む
  void open_files(File [] fileList) {
    SortingFileList sortingFileList;

    // ファイルリストのソーティング
    sortingFileList    = new SortingFileList(fileList, extensionListOfText);
    fileList = sortingFileList.sort();

    // 読み込み
    for (int i = 0; i < fileList.length; i++) { //<>//
      read_and_store(fileList[i].getAbsolutePath(), data);
    }
  }
  // 一つ分のデータを読み込んでストアする
  void read_and_store(String fname, Data data) {
    OneData onedata;
    if ((onedata = read(fname, noConversion)) == null) return; //<>//
    // データの格納
    if (data.store(onedata) == false) return;
    shortMessage.set_message("Data imported: " + onedata.filename + " " + onedata.num + " points");
    // エクスポートフォルダー未指定時は自動設定
    if (ex_file.export_folder == "") {
      File fp = new File(fname);  // ファイル名の分離と，エクスポートフォルダー未指定時に自動設定するため
      ex_file.set_export_folder(fp.getParent());
    }
  }
}

// 結合したデータをファイルに出力するクラス
class ExportFile {
  String      export_folder;
  String      fullpathname;
  String      dest_filename;
  PrintWriter output;
  
  // コンストラクター
  ExportFile() {
    dest_filename = DataFilename;
    export_folder = "";
    set_export_folder(export_folder);
  }
  // エクスポートフォルダー名の設定（ファイル名は固定）
  void set_export_folder(String path) {
    export_folder = path;
    File f = new File(export_folder, dest_filename);
    fullpathname = f.getAbsolutePath(); 
  }
  // 結合したデータのファイル出力
  boolean export_alldata(Data data) {
    OneData now;
    if (data.num <= 0)                return false;  // まだデータが無い
    if (ex_file.export_folder == "")  return false;  // エクスポートフォルダー未指定時（無いはずだが）

    output = createWriter(fullpathname);
    if (output == null) {
      shortMessage.set_message("Error: can't open output file : " + fullpathname);
      return false;
    }
    shortMessage.set_message("Start exporting to " + fullpathname);

    // データファイルの出力
    OneData onedata;
    for (int index = 0; index < data.num; index++) {
      onedata = data.body[index];
      // ヘッダーの書き込み
      output.print(onedata.filename);                                     // ファイル名
      output.print("\t" + onedata.dateString);                            // 計測日時（Ver.2.1から）
      output.print("\t" + onedata.scale);                                 // 倍率（Scale_convertがtrueの場合はこの倍率でX, Y座標は変換されて結合される）
      output.print("\t" + onedata.org_width + "\t" + onedata.org_height); // 画像の幅，高さ
      output.print("\t" + onedata.num);                                   // 計測点数
      output.print("\t" + onedata.countSkip());                           // スキップ数
      
      // データ本体の書き込み
      for (int i = 0; i < onedata.num; i++) {
        output.print("\t" + onedata.px[i] + "\t" + onedata.py[i]);                                    // X, Y座標
        // 色情報も出力する必要があるならば
        if (Merge_color_info) {
          output.print("\t" + onedata.col_R[i] + "\t" + onedata.col_G[i] + "\t" + onedata.col_B[i]);  // R, G, B
        }
      }
      // 最後の改行
      output.println();
    }    
    output.flush();
    output.close();
    shortMessage.set_message("Completed export " + data.num + " data and clear data");
    data.allclear();
    return true;
  }
}
