// 極楽画像計測（Gokuraku_measure）用可視化プログラム(Gokuraku_visualize)
// Created by Tatsuya Shirai
// National Institute of Technology, Suzuka college
// Mechanical Department
//
// Ver. 1.0 : 2022.06.08
// Ver. 2.2 : チラツキの防止，静止画像の種類を変更可能に．Define_stickの指定なし時にscaleが有効になっていなかった．visualizer -> visualize
// Ver. 3.0 : 2023.03.02 : クリックしたデータ数に加えてスキップ数もmerged.txtに含まれるが無視する，メニューの色分け

Data         data;
CurrentImage ci;
ImportFile   im_file;
ExportFile   ex_file;
MenuScreen   menuScreen;

final int Scr_w = 800;
final int Scr_h = 640;

enum Menu_status {main, setting, sizeinputing, delayinputing, linewidthinputing, filenameinputing};
Menu_status menu_status;

void setup() {
  data         = new Data();
  im_file      = new ImportFile();
  ci           = new CurrentImage();
  ex_file      = new ExportFile();
  shortMessage = new ShortMessage();
  inputInteger = new InputInteger();
  inputString  = new InputString();
  keyStatus    = new KeyStatus();
  menu_status  = Menu_status.main;

  //サイズ変更を許可する
  surface.setResizable(true);

  // 日本語フォントを使用する
  PFont font = createFont(JapaneseFont, 50);
  textFont(font);

  drop_init();
}

void draw(){
  menuScreen = new MenuScreen(8, 48, 150, 40);

  noStroke();
  if (ci.preview.playing != PreviewMode.stop) {
    ci.play(data);
    menuScreen.y = height - 16;
  } else {
    // 画面消去
    surface.setSize(Scr_w, Scr_h);
//  fill(72, 72, 72);
    background(72, 72, 72);
  
    menuScreen.display_title("Gokuraku visualize", 180, 180, 255);
    menuScreen.display_subtitle("The data file should be sorted in advance using Excel or other tools.");
  
    // メニュー表示
    menuScreen.text_color(TextColor.normal);
    if (menu_status == Menu_status.sizeinputing) {
      menuScreen.display_keyInputPrompt("Plot size");
    } else if (menu_status == Menu_status.delayinputing) {
      menuScreen.display_keyInputPrompt("Delay per image");
    } else if (menu_status == Menu_status.linewidthinputing) {
      menuScreen.display_keyInputPrompt("Line width");
    } else if (menu_status == Menu_status.filenameinputing) {
      menuScreen.display_keyInputPrompt("Image filename");
    } else if (menu_status == Menu_status.main) {
      menuScreen.text_color(TextColor.input);
      menuScreen.display_menu("[I]",           "import a merged data file from folder");
      menuScreen.display_menu("(Right clisk)", "import a merged data file");
      menuScreen.text_color(TextColor.option);
      menuScreen.display_menu("[S]",           "open sub-menu");
      menuScreen.display_menu("[D]",           "show data list(console)");
      menuScreen.display_menu("[L]",           "import define_stick file (" + (ci.stick.define_stick.length == 0 ? "none" : "defined") + ")");
      menuScreen.text_color(TextColor.normal);
      menuScreen.display_menu("[P]",           "preview images (ESC:halt / SPC:pause)");
      menuScreen.display_menu("",              "  (←, →, +SHIFT, +CTRL)");
      menuScreen.display_menu("[F]",           "select export folder");
      menuScreen.display_menu("[E]",           "export image files");
      menuScreen.text_color(TextColor.option);
      menuScreen.display_menu("[ESC]",         "quit");

      menuScreen.y += 16;
      menuScreen.display_note("Path format: " + ex_file.fullpathname);
      String str = "Imported ";
      if (data.num > 0) str += data.num + " files";
      else              str += "no data";
      menuScreen.display_note(str);
      menuScreen.y += menuScreen.dy;
    } else if (menu_status == Menu_status.setting) {
      menuScreen.dx = 64;
      menuScreen.display_menu("[1]", "change background color (=" + color2str(BG_color[ci.bg_color][0], BG_color[ci.bg_color][1], BG_color[ci.bg_color][2]) + ")");
      menuScreen.display_menu("[2]", "change plot type  (=" + ci.plotMark.get_shape() + ")");
      menuScreen.display_menu("[3]", "change plot color (=" + ci.plotMark.color_str() + ")");
      menuScreen.display_menu("[4]", "input plot size  (=" + ci.plotMark.size + ")");
      menuScreen.display_menu("[5]", "input line width (=" + ci.plotMark.lineWidth + ")"); 
      menuScreen.display_menu("[6]", "toggle enable line segment flag ("  + (ci.stick.enable_stick   ? "true" : "false") + ")");
      menuScreen.text_color(TextColor.input);
      menuScreen.display_menu("[I]", "display image with plot (" + (ci.preview.enable_image ? "true" : "false") + ")");
      menuScreen.display_menu("[S]", "change window size according to scale  (" + (ci.enable_scale         ? "true" : "false") + ")");
      menuScreen.display_menu("[C]", "do not convert input data by scale (" + im_file.noConversion + ")");
      menuScreen.text_color(TextColor.normal);
      menuScreen.display_menu("[D]", "input delay per image (="   + ci.preview.delay_per_image + "[ms], > 1)");
      menuScreen.display_menu("[N]", "input image filename (=" + ex_file.image_filename + ")");
      menuScreen.display_menu("[E]", "change image type (="     + Image_type_ext[ex_file.image_type] + ")");
      menuScreen.text_color(TextColor.option);
      menuScreen.display_menu("[Q]", "quit sub-menu");
    }
  }
  shortMessage.display_short_message(menuScreen.x, menuScreen.y);
}

void mousePressed()
{
  if (mouseButton == RIGHT) selectInput("Select a combined file:", "fileSelected");
}

void keyReleased()
{
  keyStatus.release(keyCode);
}

void keyPressed()
{
  keyStatus.push(keyCode);
  File   fp;
  int    num;
  String str;
  if (menu_status == Menu_status.sizeinputing) {
    // plot_size を修正時
    if (inputInteger.keyin(key) == false) {
      if (inputInteger.halt != true) {
        if ((num = inputInteger.value) >= 1) ci.plotMark.size = num;
        shortMessage.set_message("Change plot size to " + ci.plotMark.size);
      }        
      menu_status = Menu_status.setting;
      key = 0;
      return;
    }
  } else if (menu_status == Menu_status.delayinputing) {
    // delay_per_image を修正時
    if (inputInteger.keyin(key) == false) {
      if (inputInteger.halt != true) {
        if ((num = inputInteger.value) >= 2) ci.preview.delay_per_image = num;
        shortMessage.set_message("Change delay per image to " + ci.preview.delay_per_image + "[ms]");
      }        
      menu_status = Menu_status.setting;
      key = 0;
      return;
    }
  } else if (menu_status == Menu_status.linewidthinputing) {
    // lineWidth を修正時
    if (inputInteger.keyin(key) == false) {
      if (inputInteger.halt != true) {
        if ((num = inputInteger.value) >= 1) ci.plotMark.lineWidth = num;
        shortMessage.set_message("Change line width to " + ci.plotMark.lineWidth);
      }        
      menu_status = Menu_status.setting;
      key = 0;
      return;
    }
  } else if (menu_status == Menu_status.filenameinputing) {
    // 画像ファイルのファイル名(ex_file.image_filename） を修正時
    if (inputString.keyin(key) == false) {
      if (inputString.halt != true) {
        if ((str = inputString.value).length() > 0) {
          ex_file.image_filename = str;
          ex_file.set_export_information(null);
        }        
        shortMessage.set_message("Change image filename to " + ex_file.image_filename);
      }        
      menu_status = Menu_status.setting;
      key = 0;
      return;
    }
  } else if (menu_status == Menu_status.main) {
    switch (keyCode) {
      case ESC :
        if (ci.preview.playing != PreviewMode.stop) {
          if (ci.preview.export_enable) {
            shortMessage.set_message("Halt: exported image file : " + (ci.preview.count) + " files");
          }
          ci.preview.stop_preview();
          key = 0;
        }
        break;
      case RIGHT :  // プレビューを一時停止中にコマを移動（進む）
        if ((ci.preview.playing == PreviewMode.pause) && (ci.preview.export_enable == false)) {
          if (keyStatus.shift )    ci.preview.last_image();    // SHIFT同時押しで最終コマへ
          else if (keyStatus.ctrl) ci.preview.next_image(10);  // CTRL同時押しで10コマ先に
          else                     ci.preview.next_image();
        }
        break;
      case LEFT :   // プレビューを一時停止中にコマを移動（戻る）
        if ((ci.preview.playing == PreviewMode.pause) && (ci.preview.export_enable == false)) {
          if (keyStatus.shift)     ci.preview.first_image();   // SHIFT同時押しで最初のコマへ
          else if (keyStatus.ctrl) ci.preview.prev_image(10);  // CTRL同時押しで10コマ前に
          else                     ci.preview.prev_image();
        }
        break;
      case ' ' :
        if (ci.preview.playing == PreviewMode.playing) {       // 再生中ならば一時停止
          ci.preview.playing = PreviewMode.pause;
        } else if (ci.preview.playing == PreviewMode.pause) {  // 一時停止中ならば再生
          ci.preview.playing = PreviewMode.playing;
        }
        break;
      case 'I' : 
        // 結合データファイルのフォルダーからの読み込み
        fp = new File(im_file.import_folder);
        selectFolder("Select a import folder:", "imfolderSelected", fp);
        break;
      case 'S' :
        // 設定のサブメニューに移動
        menu_status = Menu_status.setting;
        break;
      case 'D' :
        data.show_data_list();
        break;
      case 'L' :
        fp = new File(im_file.import_folder);
        selectInput("Select a define stick:", "stickSelected", fp);
        break;
      case 'P' :
        ci.preview.start_preview();
        break;
      case 'F' :
        // エクスポートするフォルダーの選択
        fp = new File(ex_file.export_folder);
        selectFolder("Select a folder to export:", "folderSelected", fp);
        break;
      case 'E' : 
        // 画像ファイルの出力
        ex_file.start_export();
        break;
    }
  } else if (menu_status == Menu_status.setting) {
    switch (keyCode) {
      case '1' :
        ci.change_bg();
        shortMessage.set_message("Change background color to " + color2str(BG_color[ci.bg_color][0], BG_color[ci.bg_color][1], BG_color[ci.bg_color][2]));
        break;
      case '2' :
        ci.plotMark.change_shape();
        shortMessage.set_message("Change plot type to " + ci.plotMark.get_shape());
        break;
      case '3' :
        ci.plotMark.change_color();
        shortMessage.set_message("Change plot color to " + ci.plotMark.color_str());
        break;
      case '4' :
        inputInteger.start(ci.plotMark.size);
        menu_status = Menu_status.sizeinputing;
        break;
      case '5' :
        inputInteger.start(ci.plotMark.lineWidth);
        menu_status = Menu_status.linewidthinputing;
        break;
      case '6' :
        ci.stick.switch_enable_stick();
        shortMessage.set_message("Toggled enable line segment : " + ci.stick.enable_stick);
        break;
      case 'I' :
        ci.preview.switch_enable_image();
        shortMessage.set_message("Display image with plot : " + ci.preview.enable_image);
        break;
      case 'S' :
        ci.switch_enable_scale();
        shortMessage.set_message("Change window size according to scale : " + ci.enable_scale);
        break;
      case 'C' :
        im_file.switch_noConversion();
        shortMessage.set_message("Do not convert input data by scale :" + im_file.noConversion);
        break;
      case 'D' :
        inputInteger.start(ci.preview.delay_per_image);
        menu_status = Menu_status.delayinputing;
        break;
      case 'N' :
        inputString.start(ex_file.image_filename);
        menu_status = Menu_status.filenameinputing;
        break;
      case 'E' :
        ex_file.change_image_type();
        shortMessage.set_message("Change image type to " + Image_type_ext[ex_file.image_type]);
        break;
      case 'Q' :
        menu_status = Menu_status.main;
        break;
    }
    key = 0;
  }
}

// 結合ファイル選択後の処理
void fileSelected(File selection) 
{
  if (selection == null) return;
  im_file.read(selection.getAbsolutePath());
  im_file.import_folder = selection.getAbsolutePath();
}
// Stick定義ファイル選択後の処理
void stickSelected(File selection) 
{
  if (selection == null) {
    ci.stick.clearDefineStick();
    return;
  }
  ci.stick.readDefineStick(selection.getAbsolutePath());
}

// インポートフォルダー選択後の処理
void imfolderSelected(File selection) {
  if (selection == null) return;
  im_file.import_folder = selection.getAbsolutePath();
  im_file.open_files(selection.listFiles());
}
// エクスポートするフォルダーの選択
void folderSelected(File selection) {
  if (selection == null) return;  // キャンセル時
  ex_file.set_export_information(selection.getAbsolutePath());
  shortMessage.set_message("User select folder = " + ex_file.export_folder);
}

//// ドラッグ＆ドロップ関係
// ドロップされたファイルの処理
void fileSelected(List<File> fs) {
  File [] fileList = {};
  for(File f:fs){
    // ドラッグ＆ドロップされたリストの中にフォルダーが含まれていた場合は，その層までは自動的に読み込む
    if (f.isDirectory()) {
      for (File sf:f.listFiles()) {
        if (sf.isFile()) fileList = (File [])append(fileList, sf);  // ListからArrayへ変更 //<>//
      }
    }
    fileList = (File [])append(fileList, f);  // ListからArrayへ変更
  }
  if (fileList.length == 0) return;
  im_file.open_files(fileList);
}
